% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{fista.nuclear}
\alias{fista.nuclear}
\title{A helper function for implementing FISTA algorithm to estimate low-rank matrix}
\usage{
fista.nuclear(A, b, lambda, d, niter, backtracking = TRUE, phi.true)
}
\arguments{
\item{A}{A n by p design matrix}

\item{b}{A correspond vector, or a matrix}

\item{lambda}{tuning parameter}

\item{d}{model dimension}

\item{niter}{the maximum number of iterations required for applying FISTA algorithm}

\item{backtracking}{a boolean argument, indicate whether use backtracking or not}

\item{phi.true}{true model parameter, only available for simulations}
}
\value{
A list object, including
\describe{
    \item{phi.hat}{Estimated low-rank matrix}
    \item{obj.vals}{Values of objective function for all iterations}
    \item{rel.err}{Relative error to the true model parameter, only available for simulation}
}
}
\description{
Function to estimate low-rank matrix using FISTA algorithm
}
