% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{print.VARDetect.result}
\alias{print.VARDetect.result}
\title{Function to print the change points estimated by VARDetect}
\usage{
\method{print}{VARDetect.result}(x, ...)
}
\arguments{
\item{x}{a \code{VARDetect.result} class object}

\item{...}{not in use}
}
\value{
Print the estimated change points
}
\description{
Print the estimated change points of class \code{VARDetect.result}
}
\examples{
nob <- 1000
p <- 15
brk <- c(floor(nob / 3), floor(2 * nob / 3), nob + 1)
m <- length(brk)
q.t <- 1
try <- simu_var('sparse', nob = nob, k = p, lags=q.t, brk = brk, sp_pattern="off-diagonal")
data <- try$series
data <- as.matrix(data)
fit <- tbss(data, method = "sparse", q = q.t)
print(fit)
}
