% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{fitVCA}
\alias{fitVCA}
\title{Fit Variance Component Model by ANOVA or REML}
\usage{
fitVCA(form, Data, method = c("anova", "reml"), scale = TRUE,
  VarVC = TRUE, ...)
}
\arguments{
\item{form}{(formula) specifiying the variance component model (see \code{\link{anovaVCA}} and/or \code{\link{remlVCA}})}

\item{Data}{(data.frame)  containing all variables referenced in 'form'}

\item{method}{(character) either "anova" to use ANOVA Type-I estimation of variance components or "reml" to use 
restricted maximum likelihood (REML) estimation of variance component}

\item{scale}{(logical) TRUE = scale values of the response aiming to avoid numerical problems
when numbers are either very small or very large, FALSE = use original scale}

\item{VarVC}{(logical) TRUE = variance-covariance matrix of variance components will be computed, FALSE = it will not
be computed}

\item{...}{additional arguments to be passed to function \code{\link{anovaVCA}} or function \code{\link{remlVCA}}.}
}
\description{
Function serves as interface to functions \code{\link{anovaVCA}} and \code{\link{remlVCA}}
for fitting a variance component models (random models) either by ANOVA or REML. All arguments applicable
to either one of these functions can be specified (see \code{\link{anovaVCA}} or \code{\link{remlVCA}} for details).
}
\examples{
\dontrun{
#load data (CLSI EP05-A2 Within-Lab Precision Experiment) 
data(dataEP05A2_2)

# perform ANOVA-estimation of variance components
res.anova <- fitVCA(y~day/run, dataEP05A2_2, "anova")
# perform REML-estimation of variance components
res.reml <- fitVCA(y~day/run, dataEP05A2_2, "reml")

# compare scaling vs. not scaling the response
fit0 <- fitVCA(y~day/run, dataEP05A2_2, "anova", scale=TRUE)
fit1 <- fitVCA(y~day/run, dataEP05A2_2, "anova", scale=FALSE)
}
}
\seealso{
\code{\link{fitLMM}}, \code{\link{anovaVCA}}, \code{\link{remlVCA}}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
