% file MASS/muscle.d
% copyright (C) 1999 W. N. Venables and B. D. Ripley
%
\name{muscle}
\alias{muscle}
\title{
Effect of Calcium Chloride on Muscle Contraction in Rat Hearts
}
\description{
The purpose of this experiment was to assess the influence of
calcium in solution on the contraction of heart muscle in rats.
The left auricle of 21 rat hearts was isolated and on several
occasions a constant-length strip of tissue was electrically
stimulated and dipped into various concentrations of calcium
chloride solution, after which the shortening of the strip was
accurately measured as the response. 
}
\usage{
data(muscle)
}
\format{
This data frame contains the following columns:
\describe{
\item{\code{Strip}}{
which heart muscle strip was used?
}
\item{\code{Conc}}{
concentration of calcium chloride solution, in multiples of 2.2 mM.
}
\item{\code{Length}}{
the change in length (shortening) of the strip, (allegedly) in mm.
}}}
\source{
Linder, A., Chakravarti, I. M. and Vuagnat, P. (1964)
Fitting asymptotic regression curves with different asymptotes.
In
\emph{Contributions to Statistics. Presented to Professor P. C. Mahalanobis }
\emph{on the occasion of his 70th birthday,}
ed. C. R. Rao, pp. 221--228. Oxford: Pergamon Press.
}
\examples{
library(nls)
data(muscle)
A <- model.matrix(~ Strip - 1, data=muscle)
rats.nls1 <- nls(log(Length) ~ cbind(A, rho^Conc), 
   data = muscle, start = c(rho=0.1), algorithm="plinear")
B <- coef(rats.nls1)
B


st <- list(alpha = B[2:22], beta = B[23], rho = B[1])  
rats.nls2 <- nls(log(Length) ~ alpha[Strip] + beta*rho^Conc,
                  data = muscle, start = st)
rats.nls2

attach(muscle)
Muscle <- expand.grid(Conc = sort(unique(Conc)), 
                     Strip = levels(Strip))
Muscle$Yhat <- predict(rats.nls2, Muscle)
Muscle <- cbind(Muscle, logLength = rep(as.numeric(NA), 126))
ind <- match(paste(Strip, Conc), 
            paste(Muscle$Strip, Muscle$Conc))
Muscle$logLength[ind] <- log(Length)
detach()

coplot(Yhat ~ Conc | Strip, data=Muscle,
  subscripts = TRUE, xlab = "Calcium Chloride concentration (mM)",
  ylab = "log(Length in mm)", show.given = FALSE, panel = 
  function(x, y, subscripts, \dots) {
     lines(spline(x, y))
     points(x, Muscle$logLength[subscripts], \dots)
  })
}
\keyword{datasets}
