% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{create_binomial}
\alias{create_binomial}
\title{Creates a success/failure column for each IA based on counts.}
\usage{
create_binomial(data, NoIA = NULL, ObsPerBin = NULL,
  ObsOverride = FALSE, CustomBinom = NULL)
}
\arguments{
\item{data}{A data table object output by either \code{\link{bin_prop}} or
\code{\link{transform_to_elogit}}.}

\item{NoIA}{A positive integer indicating the number of interest areas defined 
when creating the study.}

\item{ObsPerBin}{A positive integer indicating the number of observations to
use in the calculation. Typically, this will be the number of samples per 
bin, which can be determined with \code{\link{check_samples_per_bin}}.}

\item{ObsOverride}{A logical value controlling restrictions on the value
provided to ObsPerBin. Default value is FALSE.}

\item{CustomBinom}{An optional parameter specifying a vector containing two 
integers corresponding to the interest area IDs to be combined.}
}
\value{
A data table with additional columns (the number of which depends on 
the number of interest areas specified) added to \code{data}.
}
\description{
\code{create_binomial} uses interest area count columns to create 
a success/failure column for each IA which is suitable for logistic regression. 
N.B.: This function will work for data with a maximum of 8 interest areas.
}
\examples{
\dontrun{
library(VWPre)
# Create binomial (success/failure) column...
df <- create_binomial(data = dat, NoIA = 4, ObsPerBin = 20)
}
}
