% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{aggregate_cov_data}
\alias{aggregate_cov_data}
\title{Get aggregates from dataset from Vancouver Open Data Portal}
\usage{
aggregate_cov_data(
  dataset_id,
  select = "count(*) as count",
  group_by = NULL,
  where = NULL,
  apikey = getOption("VancouverOpenDataApiKey"),
  refresh = FALSE
)
}
\arguments{
\item{dataset_id}{Dataset id from the Vancouver Open Data catalogue}

\item{select}{select string for aggregation, default is `count(*) as count`
It accepts \href{https://help.opendatasoft.com/apis/ods-search-v2/#select-clause}{ODSQL syntax}.}

\item{group_by}{grouping variables for the query
It accepts \href{https://help.opendatasoft.com/apis/ods-search-v2/#group-by-clause}{ODSQL syntax}.}

\item{where}{Query parameter to filter data (default `NULL` no filter)
It accepts \href{https://help.opendatasoft.com/apis/ods-search-v2/#where-clause}{ODSQL syntax}.}

\item{apikey}{Vancouver Open Data API key, default `getOption("VancouverOpenDataApiKey")`}

\item{refresh}{refresh cached data, default `FALSE``}
}
\value{
tibble format data table output
}
\description{
Get aggregates from dataset from Vancouver Open Data Portal
}
\examples{
# Count all parking tickets that relate to fire hydrants by ticket status
aggregate_cov_data("parking-tickets-2017-2019",
                   group_by = "status",
                   where = "infractiontext LIKE 'FIRE'")

}
