% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder.R
\name{Vecc_reorder}
\alias{Vecc_reorder}
\title{Univariate ordering under Vecchia approximation}
\usage{
Vecc_reorder(
  a,
  b,
  m,
  locs = NULL,
  covName = NULL,
  covParms = NULL,
  covMat = NULL
)
}
\arguments{
\item{a}{lower bound vector for TMVN}

\item{b}{upper bound vector for TMVN}

\item{m}{Vecchia conditioning set size}

\item{locs}{location (feature) matrix n X d}

\item{covName}{covariance function name from the `GpGp` package}

\item{covParms}{parameters for `covName`}

\item{covMat}{dense covariance matrix, not needed when `locs` is not null}
}
\value{
a vector of new order based on FIC assumption and maxmin ordering
}
\description{
Univariate ordering under Vecchia approximation
}
\examples{
library(lhs)
library(GpGp)
library(VeccTMVN)
set.seed(123)
n <- 100
m <- 5
locs <- lhs::geneticLHS(n, 2)
covparms <- c(1, 0.1, 0)
cov_name <- "matern15_isotropic"
cov_mat <- get(cov_name)(covparms, locs)
a <- rep(-Inf, n)
b <- runif(n)
odr_TN <- TruncatedNormal::cholperm(cov_mat, a, b)$perm
rslt <- Vecc_reorder(a, b, m,
  locs = locs, covName = cov_name,
  covParms = covparms
)
# compare order
cat(rslt$order)
cat(odr_TN)
}
