% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnd_part_TMVN.R
\name{ptmvrandn}
\alias{ptmvrandn}
\title{Simulate censored multivariate normal (MVN) as censored locations using the
  Vecchia approximation}
\usage{
ptmvrandn(
  locs,
  indCensor,
  y,
  bCensor,
  covName = NULL,
  covParms = NULL,
  m = 30,
  N = 1000,
  verbose = TRUE,
  reorder = TRUE
)
}
\arguments{
\item{locs}{location (feature) matrix n X d}

\item{indCensor}{indices of locations that have only censored observations}

\item{y}{observed (not censored) values, of length n}

\item{bCensor}{upper bound, above which observations are not censored,
can be different for different locations, of length 1 or n}

\item{covName}{covariance function name from the `GpGp` package}

\item{covParms}{parameters for `covName`}

\item{m}{Vecchia conditioning set size}

\item{N}{number of samples required}

\item{verbose}{verbose level}

\item{reorder}{whether to Vecchia univariate variable reordering}
}
\value{
n X N matrix of generated samples
}
\description{
Simulate censored multivariate normal (MVN) as censored locations using the
  Vecchia approximation
}
