% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportion_overlap.R
\name{proportion_overlap}
\alias{proportion_overlap}
\title{Proportion Overlap Calculations for Cohen's d}
\usage{
proportion_overlap(
  model = NULL,
  x_col = NULL,
  y_col = NULL,
  df = NULL,
  d = NULL
)
}
\arguments{
\item{model}{a saved independent t-test model}

\item{x_col}{name of the column that contains the factor levels OR
a numeric vector of group 1 scores}

\item{y_col}{name of the column that contains the dependent score OR
a numeric vector of group 2 scores}

\item{df}{optional dataframe that includes the x_col and y_col}

\item{d}{previously calculated d value}
}
\value{
A list of the following:

\item{u1}{Proportion of non-overlap across both distributions}
\item{u2}{Proportion that one group is more than the same
proportion in the other group}
\item{u3}{Proportion of one group that is smaller than the
median of the other group}
\item{p_o}{Proportional overlap of distributions}
}
\description{
This function calculates the proportion overlap from two independent
group d effect size calculations. Cohen's u1, u2, u3 and proportion
overlap are provided.
}
\examples{

proportion_overlap(d = .25)

}
\keyword{effect}
\keyword{overlap}
\keyword{proportion}
\keyword{size}
\keyword{u1}
\keyword{u2}
\keyword{u3}
