% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walsNB.R
\name{walsNBfitIterate}
\alias{walsNBfitIterate}
\title{Iteratively fitting walsNB, internal function for walsNB.formula and
walsNB.matrix.}
\usage{
walsNBfitIterate(
  y,
  X1,
  X2,
  link = "log",
  na.action = NULL,
  weights = NULL,
  offset = NULL,
  prior = weibull(),
  controlInitNB = controlNB(),
  keepY = TRUE,
  keepX = FALSE,
  iterate = FALSE,
  tol = 1e-06,
  maxIt = 50,
  nIt = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{y}{Count response as vector.}

\item{X1}{Design matrix for focus regressors. Usually includes a constant
(column full of 1s) and can be generated using \code{\link[stats]{model.matrix}}.}

\item{X2}{Design matrix for auxiliary regressors. Usually does not include
a constant column and can also be generated using \code{\link[stats]{model.matrix}}.}

\item{link}{specifies the link function, currently only "log" is supported.}

\item{na.action}{Not implemented yet.}

\item{weights}{Not implemented yet.}

\item{offset}{Not implemented yet.}

\item{prior}{Object of class \code{"\link[WALS]{familyPrior}"}. For example
\code{\link[WALS]{weibull}} or \code{\link[WALS]{laplace}}.}

\item{controlInitNB}{Controls estimation of starting values for one-step ML,
see \code{\link[WALS]{controlNB}}.}

\item{keepY}{If \code{TRUE}, then output keeps response.}

\item{keepX}{If \code{TRUE}, then output keeps the design matrices.}

\item{iterate}{if \code{TRUE} then the WALS algorithm is iterated using the previous
estimates as starting values.}

\item{tol}{Only used if \code{iterate = TRUE} and \code{nIt = NULL}. If the
Euclidean distance between the previous and current coefficient vector divided
by the square root of the length of the vector falls below \code{tol} and the
absolute difference between the previous and current dispersion parameter
falls below \code{tol}, then the algorithm stops. See below for more details.}

\item{maxIt}{Only used if \code{iterate = TRUE} and \code{nIt = NULL}. Aborts
iterative fitting when number of iterations exceed \code{maxIt}.}

\item{nIt}{Only used if \code{iterate = TRUE}. If this is specified, then
\code{tol} is ignored and the algorithm iterates \code{nIt} times.}

\item{verbose}{If \code{verbose = TRUE}, then it prints the iteration process
(only relevant if \code{iterate = TRUE}).}

\item{...}{Arguments to be passed to the workhorse function \code{\link[WALS]{walsNBfit}}.}
}
\value{
A list containing all elements returned from \code{\link[WALS]{walsNBfit}}
and additionally the following elements:
\item{y}{If \code{keepY = TRUE}, contains the response vector.}
\item{x}{list. If \code{keepX = TRUE}, then it is a list with elements
\code{x1} and \code{x2} containing the design matrices of the focus and
auxiliary regressors, respectively.}
\item{initialFit}{List containing information (e.g. convergence) on the
estimation of the starting values for \code{\link[WALS]{walsNBfit}}.
See return of \code{\link[WALS]{fitNB2}} for more information.}
\item{weights}{returns the argument \code{weights}.}
\item{offset}{returns the argument \code{offset}.}
\item{converged}{Logical. Only relevant if \code{iterate = TRUE}. Equals
\code{TRUE} if iterative fitting converged, else \code{FALSE}. Is \code{NULL}
if \code{iterate = FALSE}.}
\item{it}{Number of iterations run in the iterative fitting algorithm.
\code{NULL} if \code{iterate = FALSE}.}
\item{deviance}{Deviance of the fitted (conditional) NB2 regression model.}
\item{residuals}{Raw residuals, i.e. response - fitted mean.}
}
\description{
Wrapper around \code{\link[WALS]{walsNBfit}} that allows iteratively
(re-)fitting \code{\link[WALS]{walsNB}} models.
}
\details{
The parameter \code{tol} is used to control the convergence of the iterative
fitting algorithm. Let \eqn{i} be the current iteration step for the
coefficient vector \eqn{\beta_{i} = (\beta_{i,1}, \ldots, \beta_{i,k})'},
\eqn{k > 0}, and dispersion parameter \eqn{\rho_{i}}. If
\deqn{\frac{||\beta_{i} - \beta_{i-1}||_{2}}{\sqrt{k}}
= \sqrt{\frac{\sum_{j = 1}^{k} (\beta_{i,j} - \beta_{i-1,j})^{2}}{k}} < \texttt{tol},}
and
\deqn{|\rho_{i} - \rho_{i-1}| < \texttt{tol},}
then the fitting process is assumed to have converged and stops.
}
\examples{
data("NMES1988", package = "AER")
NMES1988 <- na.omit(NMES1988)
form <- (visits ~ health + chronic + age + insurance + adl + region + gender
         + married + income + school + employed)
X <- model.matrix(form, data = NMES1988)
focus <- c("(Intercept)", "healthpoor", "healthexcellent", "chronic", "age",
        "insuranceyes")
aux <- c("adllimited", "regionnortheast", "regionmidwest", "regionwest",
         "gendermale", "marriedyes", "income", "school", "employedyes")
X1 <- X[, focus]
X2 <- X[, aux]
y <- NMES1988$visits

str(walsNBfitIterate(y, X1, X2, prior = weibull(), link = "log",
                     method = "fullSVD", iterate = TRUE))

}
\seealso{
\link{walsNB}, \link{walsNBfit}.
}
