% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WL.R
\name{MME_var}
\alias{MME_var}
\alias{MMEm_var}
\alias{MLE_var}
\alias{MLEc_var}
\title{Asymptotic covariance matrix of estimators}
\usage{
MME_var(l, p, n)

MMEm_var(l, p, n)

MLE_var(l, p, n)

MLEc_var(l, p, n)
}
\arguments{
\item{l}{a numeric value.}

\item{p}{a numeric value.}

\item{n}{a numeric value.}
}
\value{
A matrix of asymptotic covariance of lambda and phi.
}
\description{
These four functions: \code{MME_var},
\code{MMEm_var}, \code{MLE_var} and \code{MLEc_var} provide asymptotic covariance matrixs for MME,
modified MME, MLE, MLEc, repectively. All of these can be calculated to a closed form value.
}
\details{
These functions implement formulas given in Hyoung-Moon Kim. et al. (2020).
}
\examples{
data <- fail_fiber
n <- length(data)
mme <- MME_WL(data)
modified_mme <- MMEm_WL(data)
mle <- MLE_WL(data, mme[2])
mlec <- MLEc_WL(data)
MME_var(mme[1],mme[2],n)
MMEm_var(modified_mme[1],modified_mme[2],n)
MLE_var(mle[1],mle[2],n)
MLEc_var(mlec[1],mlec[2],n)

}
\references{
Hyoung-Moon Kim. and Yu-Hyeong Jang. (2020). New Closed-Form Estimators for
Weighted Lindley Distribution. \emph{ }, submitted.
}
