% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obsplot.R
\name{obsplot}
\alias{obsplot}
\alias{obsplot.default}
\alias{obsplot.tidal}
\alias{obsplot.tidalmean}
\title{Plot observed response variable and salinity/flow data}
\usage{
obsplot(dat_in, ...)

\method{obsplot}{default}(dat_in, lines = TRUE, logspace = TRUE,
  dt_rng = NULL, pretty = TRUE, col = "black", lwd = 1, size = 2,
  alpha = 1, ...)

\method{obsplot}{tidal}(dat_in, ...)

\method{obsplot}{tidalmean}(dat_in, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to \code{\link[ggplot2]{geom_line}}}

\item{lines}{logical indicating if a line plot is used, otherwise points}

\item{logspace}{logical indicating if plots are in log space}

\item{dt_rng}{Optional chr string indicating the date range of the plot. Must be two values in the format 'YYYY-mm-dd' which is passed to \code{\link{as.Date}}.}

\item{pretty}{logical indicating if my subjective idea of plot aesthetics is applied, otherwise the \code{\link[ggplot2]{ggplot}} default themes are used}

\item{col}{chr string of plot color to use}

\item{lwd}{numeric value indicating width of lines}

\item{size}{numeric value indicating size of points}

\item{alpha}{numeric value indicating transparency of points or lines}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that can be further modified
}
\description{
Plot observed response variable and salinity/flow time series from a tidal object
}
\examples{

## load a fitted tidal object
data(tidfit)

## plot using defaults
obsplot(tidfit)
 
## changing default
obsplot(tidfit, alpha = 0.5, size = 4, col = 'blue', lines = FALSE)

## plot a tidalmean object
data(tidfitmean)

obsplot(tidfitmean)
}
\seealso{
\code{\link{fitplot}}
}

