% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasyrplot.R
\name{seasyrplot}
\alias{seasyrplot}
\alias{seasyrplot.tidal}
\alias{seasyrplot.tidalmean}
\title{Plot seasonal model response by years}
\usage{
seasyrplot(dat_in, ...)

\method{seasyrplot}{tidal}(dat_in, years = NULL, tau = NULL,
  predicted = TRUE, logspace = TRUE, col_vec = NULL, grids = TRUE,
  pretty = TRUE, lwd = 0.5, alpha = 1, ...)

\method{seasyrplot}{tidalmean}(dat_in, years = NULL, tau = NULL,
  predicted = TRUE, logspace = TRUE, col_vec = NULL, grids = TRUE,
  pretty = TRUE, lwd = 0.5, alpha = 1, ...)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to other methods}

\item{years}{numeric vector of years to plot}

\item{tau}{numeric vector of quantiles to plot, defaults to all in object if not supplied}

\item{predicted}{logical indicating if standard predicted values are plotted, default \code{TRUE}, otherwise normalized predictions are plotted}

\item{logspace}{logical indicating if plots are in log space}

\item{col_vec}{chr string of plot colors to use, passed to \code{\link{gradcols}}.  Any color palette from RColorBrewer can be used as a named input. Palettes from grDevices must be supplied as the returned string of colors for each palette.}

\item{grids}{logical indicating if grid lines are present}

\item{pretty}{logical indicating if my subjective idea of plot aesthetics is applied, otherwise the \code{\link[ggplot2]{ggplot}} default themes are used}

\item{lwd}{numeric value indicating width of lines}

\item{alpha}{numeric value indicating transparency of points or lines}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that can be further modified
}
\description{
Plot seasonal model response by years on a common axis
}
\details{
The plot is similar to that produced by \code{\link{seasplot}} except the model estimates are plotted for each year as connected lines, as compared to loess lines fit to the model results.  \code{\link{seasyrplot}} is also similar to \code{\link{sliceplot}} except the x-axis and legend grouping variable are flipped. This is useful for evaluating between-year differences in seasonal trends.

Multiple predictions per month are averaged for a smoother plot. 

Note that the year variable used for color mapping is treated as a continuous variable although it is an integer by definition.
}
\examples{

## load a fitted tidal object
data(tidfit)

# plot using defaults
seasyrplot(tidfit)

# get the same plot but use default ggplot settings
seasyrplot(tidfit, pretty = FALSE)

# plot specific quantiles
seasyrplot(tidfit, tau = c(0.9))

# plot the normalized predictions
seasyrplot(tidfit, predicted = FALSE)

# modify the plot as needed using ggplot scales, etc.

library(ggplot2)

seasyrplot(tidfit, pretty = FALSE, linetype = 'dashed') + 
 theme_classic() + 
 scale_y_continuous(
   'Chlorophyll', 
   limits = c(0, 5)
   )
   
# plot a tidalmean object
data(tidfitmean)

seasyrplot(tidfitmean)    
}
\seealso{
\code{\link{seasplot}}, \code{\link{sliceplot}}
}

