#' Math Pre-test Dataset
#'
#' This dataset contains mathematics pretest data prepared by the authors (Keller et al., 2022), collected from
#' 2,200 Amazon Mechanical Turk workers.
#' The test draws on a combination of self-written items and items from the ETS Kit of Factor-Referenced
#' Cognitive Tests.
#' It consists of 12 items: seven assessing general mathematics aptitude,
#' and five focusing on simplifying algebraic expressions involving exponents.
#'
#'
#' @name Math_Pre_WSC
#' @docType data
#' @format Math_Pre_WSC is a data frame with 2200 cases (rows) and 12 variables (columns).
#' The variables are named item_1, item_2, ... , item_12.
#'
#' @usage data(Math_Pre_WSC)
#'
#' @references R. B. Ekstrom, J. W. French, H. H. Harman, and D. Dermen. Manual for Kit of
#' Factor- Referenced Cognitive Tests. Educational Testing Service, 1976.
#'
#' @keywords datasets
#'
#' @examples
#' Math_Pre_WSC

NULL
