% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{graphROC}
\alias{graphROC}
\title{calculate AUC.}
\usage{
graphROC(modelPredictions, yValues)
}
\arguments{
\item{modelPredictions}{numeric predictions (not empty)}

\item{yValues}{logical truth (not empty, same lenght as model predictions)}
}
\value{
line graph, point graph, and area under curve
}
\description{
Based on:
 http://blog.revolutionanalytics.com/2016/08/roc-curves-in-two-lines-of-code.html
}
\details{
See also https://github.com/WinVector/sigr
}
\examples{

set.seed(34903490)
x = rnorm(50)
y = 0.5*x^2 + 2*x + rnorm(length(x))
frm = data.frame(x=x,yC=y>=as.numeric(quantile(y,probs=0.8)))
WVPlots::graphROC(frm$x, frm$yC)

}
