% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionPlot.R
\name{PlotDistDensityBeta}
\alias{PlotDistDensityBeta}
\title{Plot an empirical density with the matching beta distribution}
\usage{
PlotDistDensityBeta(frm, xvar, title)
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{title}{title to place on plot}
}
\description{
Compares empirical data to a beta distribution with the same mean and standard deviation.
}
\details{
Plots the empirical density, the theoretical matching beta, the mean value,
and plus/minus one standard deviation from the mean.
}
\examples{

set.seed(52523)
d <- data.frame(wt=rbeta(100,shape1=1,shape2=0.5))
PlotDistDensityBeta(d,'wt','example')

}
