% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddMethods.R
\name{AddMethods}
\alias{AddMethods}
\title{AddMethods}
\usage{
AddMethods(server, username, password, methods)
}
\arguments{
\item{server}{The URL of the web service ending with /services or with ?wsdl,
for example: http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx?wsdl
alternatively you can specify the JSON API url like:
http://worldwater.byu.edu/app/index.php/default/services/api/}

\item{username}{The valid HydroServer Lite username, for example "admin"}

\item{password}{The valid HydroServer Lite password, for example "password"}

\item{methods}{The valid table of methods. This table must have the following columns:
MethodDescription, MethodLink.}
}
\value{
A table of the added methods, with two extra columns:
MethodID (the ID assigned by the server),
Status (the status showing if the method was added: OK or Error). If the status is Error, then
the Error message with reason why the method could not be added is also shown.
}
\description{
This function adds a table of methods to HydroServer Lite.
The input must be a data.frame with all required ODM 'method' fields
NOTE: this only works with HydroServer Lite that implements the JSON API.
you must specify a valid server url, user name, and password for the HydroServer.
The examples here use the 'sandbox' HydroServer on http://worldwater.byu.edu/app/
with the username: admin and password: password.
}
\examples{
user <- "admin"
pass <- "password"
server <- "http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx"
#make random site codes
random_description <- sprintf("R Test Method \%04d",sample(1:10000, 1))
random_link <- "http://example.com"
my_methods <- data.frame(
  MethodDescription = random_description,
  MethodLink = random_link
)

added_methods <- AddMethods(server, username=user, password=pass,
                                methods=my_methods)
}
\keyword{waterml}

