% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoordBase.R, R/RcppExports.R
\name{convert}
\alias{convert}
\alias{convert.coords}
\alias{convert.waypoints}
\title{Convert the Format of "coords" and "waypoints" Objects}
\usage{
convert(x, ...)

\method{convert}{coords}(x, fmt, ...)

\method{convert}{waypoints}(x, fmt, ...)
}
\arguments{
\item{x}{object of class \code{"\link{coords}"} created by function \code{\link{as_coords}()}, or
class \code{"\link{waypoints}"} created by function \code{\link{as_waypoints}()}.}

\item{...}{further arguments passed to or from other methods.}

\item{fmt}{\code{integer}, \code{1L}, \code{2L} or \code{3L}, specifying the required coordinate
format.}
}
\value{
The original argument \code{x}, an object of class \code{"coords"} or \code{"waypoints"} with
values converted as described under \emph{details} and a revised \code{"fmt"} attribute
reflecting the new format.
}
\description{
Convert the format of objects of class \code{"coords"} or \code{"waypoints"} between (i)
decimal degrees, (ii) degrees and minutes, and (iii) degrees, minutes and seconds.
}
\details{
The \code{fmt} argument should be \code{1L} to convert to  \emph{decimal degrees}, \code{2L}, to
convert to \emph{degrees and minutes}, and \code{3L} to convert to \emph{degrees, minutes and
seconds}. On conversion of a \code{"coords"} object, the original argument \code{x} is modified
to have a decimal point after the number of whole degrees in the case of decimal degrees, after
the number of whole minutes in the case of degrees and minutes, and after the number of whole
seconds in the case of degrees, minutes and seconds.

Prior to conversion, the \code{"coords"} or \code{"waypoints"} object to be converted is checked
to ensure its values represent valid geographic locations as described under
\code{\link{validate}()}.
}
\examples{
## Continuing example from `as_coords()`...
\dontshow{
   dm <-
       c(5130.4659, 4932.7726, 4806.4339, 3853.3696, 0.0000, -3706.7044, -5306.2869, -2514.4093,
       -007.6754, 1823.9137, -12246.7203, -7702.1145, 0.0000, -1217.3178, 7331.0370, -5731.1536)
   names(dm) <- 
       rep(c("Nelson's Column", "Ostravice", "Tally Ho", "Washington Monument", "Null Island",
             "Tristan da Cunha", "Mawson Peak", "Silvio Pettirossi International Airport"), 2)
   invisible(as_coords(dm, fmt = 2))
   latlon(dm) <- rep(c(TRUE, FALSE), each = 8)
}

## Named "coords" object in degrees and minutes with
## eight values each of latitude and longitude
dm

## Convert to degrees, minutes and seconds (fmt = 3)
convert(dm, 3)

## Convert to decimal degrees (fmt = 1)
convert(dm, 1)

## Show converted values as an ordinary R numeric vector
as.numeric(dm)

###
## Continuing example from `as_waypoints()`...
\dontshow{
   wp <- data.frame(
       name = c("Nelson's Column", "Ostravice", "Tally Ho", "Washington Monument", "Null Island",
                "Tristan da Cunha", "Mawson Peak", "Silvio Pettirossi International Airport"),
       lat = c(513027.95, 493246.36, 480626.04, 385322.18, 0, -370642.26, -530617.21, -251424.56),
       lon = c(-00740.53, 182354.82, -1224643.22, -770206.87, 0, -121719.07, 733102.22, -573109.21)
   )
   invisible(as_waypoints(wp, fmt = 3))
}

## "waypoints" object in degrees, minutes and seconds
wp

## Convert to degrees and minutes (fmt = 2)
convert(wp, 2)

## Convert to decimal degrees (fmt = 1)
convert(wp, 1)

## Show converted values as an ordinary R data frame
as.data.frame(wp)

rm(dm, wp)


}
\seealso{
\code{"\link{coords}"}, \code{"\link{waypoints}"} and \code{\link{validate}()}.

Other coordsandway: 
\code{\link{coords}},
\code{\link{waypoints}}
}
\concept{coordsandway}
\keyword{programming}
