# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'This function calcuates the liklihood of the model using integration by adaptive quadrature 
#'@param y a numeric vector, the response.
#'@param yhat the current predicted values of the response
#'@param level an integer that respresents the number of levels in the likelihood
#'         that is desired. In a two level model this function will be called
#'         with l=2 and it will recurse and call itself with l=1
#'@param Z a list of the Z matricies where the index of Z indicates the level.
#'          of the Z matri. Z[[1]] is NULL because there is no individual lavel Zs.
#'@param ZFull Z expended such that each Z[[i]] matrix contains  one row for each observation (ie each element has same number of rows as original data)
#'@param Qi the scaling factor for the adaptive quadratures (per group)
#'@param QiFull the scaling factors for adaptive quarature points duplicated so each element has one row per observation (like Zfull)
#'@param omega a list of the b estimates for ech group
#'@param omegaFull numeric, the b estimates for each group duplicated so each element has one row per observation (like Zfull)
#'@param C a list of Cholesky decompositions of the Sigma matricies.
#'         C[[1]] is simply the residual variance (a scalar) while C[[l]] for 
#'         l > 1 is a matrix with the name number of rows and columns as the 
#'         Z matrix for that level.
#'@param qp Gaussian quadrature result from statmod::gauss.quad.
#'@param W list of weight matricies. must have `w` and `index` columns
#'@param top boolean set to TRUE to return a single scalar, otherwise returns a vector
#'@param verbose boolean set to TRUE to get verbose output
#'@param acc numeric, accuracy of the mpfr
#'@param atPoint boolean, indicates likelihood should be calculated at single point
#'               at the top level and then integrated below that. This is useful
#'               for finding the maximum posterior (or likelihood) extimate for 
#'               the random effects
#'@param integralMultiplierExponent a single integer, the function evaluates the
#'                                  integral times the randome effect to this power
#'                                  when set to 0, it is just the log-likelhood
#'                                  when set to 1, this can be used to estimate the
#'                                  expected value.
#'@param integralZColumn is the column index of Z to use integralMultiplierExponent on
#'                       only one random effect at a time can be integrated over, and the integration happens at the top level.
#'
#'@description
#'calculates the log-likelihood of an l level mixed model using adaptive quadrature.
#'the genral model is y = Xb + ZU + e
#'but that values of beta and U are not included in the call. Instead this information
#'is contained in yhat which incorporates Xb at the top level and all relevant 
#'Zu information at lower levels.
#'@author Huade Huo, Paul Bailey, Claire Kelley
#'@export
calc_lin_lnl_quad_fast <- function(y, yhat, level, Z, Qi, omega, W, C, qp, omegaFull, QiFull, ZFull, top = TRUE, atPoint = FALSE, integralMultiplierExponent = 0L, integralZColumn = 1L, verbose = TRUE, acc = 120L) {
    .Call(`_WeMix_calc_lin_lnl_quad_fast`, y, yhat, level, Z, Qi, omega, W, C, qp, omegaFull, QiFull, ZFull, top, atPoint, integralMultiplierExponent, integralZColumn, verbose, acc)
}

