#' @title WikidataQueryServiceR: An R Wrapper For Wikidata Query Service API
#' @description This is an R wrapper for the
#'   \href{https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service}{Wikidata Query Service}
#'   (WDQS) which provides a way for tools to query Wikidata via
#'   \href{https://en.wikipedia.org/wiki/SPARQL}{SPARQL}.
#' @details \href{https://www.mediawiki.org/wiki/Wikidata_query_service}{Wikidata Query Service}
#'   is maintained by Wikimedia Foundation's \href{https://www.mediawiki.org/wiki/Wikimedia_Discovery}{Discovery}
#'   Department.
#' @references \itemize{
#'   \item \href{https://www.mediawiki.org/wiki/Wikidata_query_service/User_Manual}{WDQS User Manual}
#'   \item \href{https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries/examples}{SPARQL Query Examples} for WDQS
#'   \item \href{http://programminghistorian.org/lessons/graph-databases-and-SPARQL}{Using SPARQL to access Linked Open Data}
#'     by Matthew Lincoln
#'   \item Interesting or illustrative \href{https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/queries}{SPARQL queries}
#'     for Wikidata
#'   \item Wikidata \href{https://www.wikidata.org/wiki/Wikidata:SPARQL_query_service/2016_SPARQL_Workshop}{2016 SPARQL Workshop}
#' }
#' @aliases WDQS
#' @docType package
#' @name WDQS-package
NULL
