% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{query_wikidata}
\alias{query_wikidata}
\title{Send one or more SPARQL queries to WDQS}
\usage{
query_wikidata(sparql_query, format = c("simple", "smart"), ...)
}
\arguments{
\item{sparql_query}{SPARQL query (can be a vector of queries)}

\item{format}{"simple" uses CSV and returns pure character data frame, while
"smart" fetches JSON-formatted data and returns a data frame with datetime
columns converted to POSIXlt}

\item{...}{Additional parameters to supply to \code{\link[httr]{GET}}}
}
\value{
A data.frame
}
\description{
Makes a GET request to Wikidata Query Service SPARQL endpoint.
}
\examples{
# Cats on Wikidata:
sparql_query <- 'SELECT ?item ?itemLabel
WHERE
{
  ?item wdt:P31 wd:Q146 .
  SERVICE wikibase:label { bd:serviceParam wikibase:language "en" }
}
LIMIT 10'
query_wikidata(sparql_query)

\dontrun{
sparql_query <- "#Recent Events
SELECT ?event ?eventLabel ?date
WHERE
{
  # find events
  ?event wdt:P31/wdt:P279* wd:Q1190554.
  # with a point in time or start date
  OPTIONAL { ?event wdt:P585 ?date. }
  OPTIONAL { ?event wdt:P580 ?date. }
  # but at least one of those
  FILTER(BOUND(?date) && DATATYPE(?date) = xsd:dateTime).
  # not in the future, and not more than 31 days ago
  BIND(NOW() - ?date AS ?distance).
  FILTER(0 <= ?distance && ?distance < 31).
  # and get a label as well
  OPTIONAL {
    ?event rdfs:label ?eventLabel.
    FILTER(LANG(?eventLabel) = \\"en\\").
  }
}
# limit to 10 results so we don't timeout
LIMIT 10"

# "smart" format converts all datetime columns to POSIXlt
query_wikidata(sparql_query, format = "smart")
}
}

