% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{set_parameters}
\alias{set_parameters}
\title{Function that regulates the specifications of the \link{xdnuts} function.}
\usage{
set_parameters(
  N_init1 = 50L,
  N_adapt = 200L,
  N_init2 = 75L,
  burn_adapt_ratio = 0.1,
  keep_warm_up = FALSE,
  recycle_only_init = TRUE,
  max_treedepth = 10L,
  max_treedepth_init = 10L,
  eps_jitter = 0.1,
  L_jitter = 3L,
  gamma = 0.05,
  kappa = 0.75,
  delta = NULL,
  t0 = 10L,
  M_type = "dense",
  refresh = 0.1,
  l_eps_init = NA_real_,
  different_stepsize = FALSE,
  mu = NA_real_,
  M_cont = NULL,
  M_disc = NULL
)
}
\arguments{
\item{N_init1}{an integer that regulates the number of samples used to
adapt the step size.}

\item{N_adapt}{an integer that regulates the number of samples used to
estimate the Mass Matrix with fixed step size.}

\item{N_init2}{an integer that regulates the number of samples used to
adapt the step size after the estimation of the Mass Matrix.}

\item{burn_adapt_ratio}{a numeric scalar \eqn{\in (0,1]} indicating the ratio of warm-up
samples to discard in order to estimate the covariance matrix of the parameters.}

\item{keep_warm_up}{a logical scalar that determines whether the warm-up samples should be returned.}

\item{recycle_only_init}{a logical value which disables the recycling of the
samples from each trajectory once the warm-up phase has terminated.}

\item{max_treedepth}{an integer that regulates the maximum depth of
the binary tree used to approximate Hamilton equation for the exploration
of each energy level set of the phase space.}

\item{max_treedepth_init}{an integer that controls the maximum depth of
the binary tree during the step-size adaptation phase. Setting a smaller value 
can help avoid wasting valuable time on low-probability areas with suboptimal 
algorithm parameters.}

\item{eps_jitter}{a numeric scalar which regulates the amount of jittering
used to perturb the value of the step size for each iteration of the chain
after the warm-up phase.}

\item{L_jitter}{an integer scalar that regulates the amount of jittering used to perturb the
value of the trajectory length if this is specified to be constant.
This occurs when the classic Hamiltonian Monte Carlo algorithm is used through the 
\code{method = "HMC"} option in the \link{xdnuts} function. If \code{L_jitter} \eqn{\geq 1}
each trajectory length is sampled uniformly inside the interval [L - L_jitter , L + L_jitter].}

\item{gamma}{a numeric value that, in the Nesterov Dual Averaging algorithm, regulates 
the sensitivity of the step size updating scheme to fluctuations in the estimate of the 
mean Metropolis acceptance probability.}

\item{kappa}{a numeric value that regulates the vanishing of Nesterov Dual Averaging
algorithm for the estimation of the step size.}

\item{delta}{a vector containing the Metropolis acceptance probabilities, 
including both the global and those related to potential differences. Default values are (0.8,0.6).
If the second element of the vector is set to \code{NA}, then the step size calibration is conducted 
solely through the global acceptance probabilities.}

\item{t0}{an integer value that makes Nesterov Dual Averaging
algorithm for the estimation of the step size less sensitive to early iterations.}

\item{M_type}{a character value specifying the type of Mass Matrix to estimate:\itemize{
\item{\code{"identity"} no Mass Matrix estimation is done.}
\item{\code{"diagonal"} a diagonal Mass Matrix is estimated during the warm-up phase.}
\item{\code{"dense"} a full dense Mass Matrix is estimated during the warm-up phase.}
}}

\item{refresh}{a numeric scalar bounded in \eqn{(0,1)} which regulates the update frequency of
the displayed sampling process state. Default values is 0.1, meaning every 10\% of the total samples.}

\item{l_eps_init}{a numeric scalar containing the logarithm of the initial value for the step size
used to approximate Hamilton differential equation for phase space exploration.}

\item{different_stepsize}{a boolean value indicating where the adaptation scheme should adapt different step size. 
If \code{TRUE}, a global step size is adapted via Nesterov Dual Averaging algorithm. 
At the same time, for each empirical reflection rate of each component treated as discontinuous the same
algorithm is exploited and the difference between these is obtained through the updating of the discontinuous
components Mass Matrix. Default value is \code{FALSE}.}

\item{mu}{a numeric scalar containing the value to which the step size is shrunken during the warm-up phase.}

\item{M_cont}{a vector of length-\eqn{d-k} if \code{M_type = "diagonal"} or a \eqn{(d-k) \times (d-k)} matrix
if \code{M_type = "dense"} containing an initial estimate for the Mass Matrix
(the inverse of the parameters covariance matrix).
If you want to keep it fixed, they should specify \code{N_adapt = 0}.}

\item{M_disc}{a vector of length-\eqn{k} if \code{M_type = "diagonal"} or 
\code{M_type = "dense"} containing an initial estimate for the Mass Matrix
(the inverse of the parameters covariances).
If one wants to keep it fixed, they should specify \code{N_adapt = 0}.}
}
\value{
an object of class \code{control_xdnuts} containing a named list with all the above parameters.
}
\description{
Function that regulates the specifications of the \link{xdnuts} function.
}
