% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xMEabf.r
\name{xMEabf}
\alias{xMEabf}
\title{Function to conduct colocalisation analysis through Wakefield's Approximate Bayes Factor approach integrating GWAS and eQTL summary data}
\usage{
xMEabf(eqtl.summary, gwas.summary, prior.eqtl = 1e-04,
prior.gwas = 1e-04, prior.both = 1e-05)
}
\arguments{
\item{eqtl.summary}{an input eQTL summary data for a region (eg the
eQTLs for a gene), a list with mandatory components 'beta' (a vector
for eQTL effect size), 'varbeta' (a vector for beta variance), 'N' (an
integer specifying number of samples), 'MAF' (minor allele frequency,
eg effect allele frequency), 'snp' (a vector for dbSNP identity)}

\item{gwas.summary}{an input GWAS summary data, a list with mandatory
components 'beta' (a vector for GWAS SNP effect size), 'varbeta' (a
vector for beta variance), 'snp' (a vector for dbSNP identity)}

\item{prior.eqtl}{the prior probability an eQTL associated with the
eQTL trait. The default value is 1e-4}

\item{prior.gwas}{the prior probability an SNP associated with the GWAS
trait. The default value is 1e-4}

\item{prior.both}{the prior probability an eQTL/SNP associated with
both eQTL/GWAS traits. The default value is 1e-5}
}
\value{
a list with two compenents (1) the component 'summary', a vector of
'nsnps' (number of SNPs analysed), 'PP.H0.abf' (posterior probabilities
of H0 - no causal variant), 'PP.H1.abf' (posterior probabilities of H1
- causal variant for eQTL trait only), 'PP.H2.abf' (posterior
probabilities of H2 - causal variant for GWAS trait only), 'PP.H3.abf'
(posterior probabilities of H3 - two distinct causal variants), and
'PP.H4.abf' (posterior probabilities of H4 - one shared causal
variant), and (2) the component 'results', a data frame with a column
'snp' (SNPs analysed), columns for eQTL statistics calcualted
('eqtl.V', 'eqtl.z', 'eqtl.r' and 'eqtl.lABF'), columns for GWAS
statistics calculated ('gwas.V', 'gwas.z', 'gwas.r' and 'gwas.lABF'), a
column 'both.sum.lABF' (the sum of 'eqtl.lABF' and 'gwas.lABF') and a
column 'SNP.PP.H4' (the posterior probability of the SNP being causal
for both traits).
}
\description{
\code{xMEabf} is supposed to conduct colocalisation analysis
integrating GWAS and eQTL summary data through Wakefield's Approximate
Bayes Factor (ABF).
}
\examples{
\dontrun{
res <- xMEabf(eqtl.summary, gwas.summary)
utils::write.table(res$results, file="df_abf.txt", row.names=F,
col.names=T, quote=F, sep="\\t")
}
}
\seealso{
\code{\link{xMEabf}}
}
