/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.NumericValueEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.StringValueEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.DGet;
import org.apache.poi.ss.formula.functions.DMin;
import org.apache.poi.ss.formula.functions.Function3Arg;
import org.apache.poi.ss.formula.functions.IDStarAlgorithm;
import org.apache.poi.ss.util.NumberComparer;

public final class DStarRunner
implements Function3Arg {
    private final DStarAlgorithmEnum algoType;

    public DStarRunner(DStarAlgorithmEnum algorithm) {
        this.algoType = algorithm;
    }

    @Override
    public final ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length == 3) {
            return this.evaluate(srcRowIndex, srcColumnIndex, args[0], args[1], args[2]);
        }
        return ErrorEval.VALUE_INVALID;
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval database, ValueEval filterColumn, ValueEval conditionDatabase) {
        int fc;
        if (!(database instanceof TwoDEval) || !(conditionDatabase instanceof TwoDEval)) {
            return ErrorEval.VALUE_INVALID;
        }
        TwoDEval db = (TwoDEval)database;
        TwoDEval cdb = (TwoDEval)conditionDatabase;
        try {
            fc = DStarRunner.getColumnForName(filterColumn, db);
        }
        catch (EvaluationException e) {
            return ErrorEval.VALUE_INVALID;
        }
        if (fc == -1) {
            return ErrorEval.VALUE_INVALID;
        }
        IDStarAlgorithm algorithm = null;
        switch (this.algoType) {
            case DGET: {
                algorithm = new DGet();
                break;
            }
            case DMIN: {
                algorithm = new DMin();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected algorithm type " + (Object)((Object)this.algoType) + " encountered.");
            }
        }
        for (int row = 1; row < db.getHeight(); ++row) {
            boolean matches = true;
            try {
                matches = DStarRunner.fullfillsConditions(db, row, cdb);
            }
            catch (EvaluationException e) {
                return ErrorEval.VALUE_INVALID;
            }
            if (!matches) continue;
            try {
                ValueEval currentValueEval = DStarRunner.solveReference(db.getValue(row, fc));
                boolean shouldContinue = algorithm.processMatch(currentValueEval);
                if (shouldContinue) continue;
                break;
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
        }
        return algorithm.getResult();
    }

    private static ValueEval solveReference(ValueEval field) throws EvaluationException {
        if (field instanceof RefEval) {
            RefEval refEval = (RefEval)field;
            if (refEval.getNumberOfSheets() > 1) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return DStarRunner.solveReference(refEval.getInnerValueEval(refEval.getFirstSheetIndex()));
        }
        return field;
    }

    private static int getColumnForTag(ValueEval nameValueEval, TwoDEval db) throws EvaluationException {
        int resultColumn = -1;
        if (nameValueEval instanceof NumericValueEval) {
            double doubleResultColumn = ((NumericValueEval)nameValueEval).getNumberValue();
            if (doubleResultColumn - (double)(resultColumn = (int)doubleResultColumn) != 0.0) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            --resultColumn;
        } else {
            resultColumn = DStarRunner.getColumnForName(nameValueEval, db);
        }
        return resultColumn;
    }

    private static int getColumnForName(ValueEval nameValueEval, TwoDEval db) throws EvaluationException {
        String name = DStarRunner.getStringFromValueEval(nameValueEval);
        return DStarRunner.getColumnForString(db, name);
    }

    private static int getColumnForString(TwoDEval db, String name) throws EvaluationException {
        int resultColumn = -1;
        for (int column = 0; column < db.getWidth(); ++column) {
            ValueEval columnNameValueEval = db.getValue(0, column);
            String columnName = DStarRunner.getStringFromValueEval(columnNameValueEval);
            if (!name.equals(columnName)) continue;
            resultColumn = column;
            break;
        }
        return resultColumn;
    }

    private static boolean fullfillsConditions(TwoDEval db, int row, TwoDEval cdb) throws EvaluationException {
        for (int conditionRow = 1; conditionRow < cdb.getHeight(); ++conditionRow) {
            boolean matches = true;
            for (int column = 0; column < cdb.getWidth(); ++column) {
                boolean columnCondition = true;
                ValueEval condition = null;
                try {
                    condition = DStarRunner.solveReference(cdb.getValue(conditionRow, column));
                }
                catch (RuntimeException e) {
                    columnCondition = false;
                }
                if (condition instanceof BlankEval) continue;
                ValueEval targetHeader = DStarRunner.solveReference(cdb.getValue(0, column));
                if (!((targetHeader = DStarRunner.solveReference(targetHeader)) instanceof StringValueEval)) {
                    throw new EvaluationException(ErrorEval.VALUE_INVALID);
                }
                if (DStarRunner.getColumnForName(targetHeader, db) == -1) {
                    columnCondition = false;
                }
                if (columnCondition) {
                    ValueEval value = db.getValue(row, DStarRunner.getColumnForName(targetHeader, db));
                    if (DStarRunner.testNormalCondition(value, condition)) continue;
                    matches = false;
                    break;
                }
                if (DStarRunner.getStringFromValueEval(condition).isEmpty()) {
                    throw new EvaluationException(ErrorEval.VALUE_INVALID);
                }
                throw new NotImplementedException("D* function with formula conditions");
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    private static boolean testNormalCondition(ValueEval value, ValueEval condition) throws EvaluationException {
        if (condition instanceof StringEval) {
            String conditionString = ((StringEval)condition).getStringValue();
            if (conditionString.startsWith("<")) {
                String number = conditionString.substring(1);
                if (number.startsWith("=")) {
                    number = number.substring(1);
                    return DStarRunner.testNumericCondition(value, operator.smallerEqualThan, number);
                }
                return DStarRunner.testNumericCondition(value, operator.smallerThan, number);
            }
            if (conditionString.startsWith(">")) {
                String number = conditionString.substring(1);
                if (number.startsWith("=")) {
                    number = number.substring(1);
                    return DStarRunner.testNumericCondition(value, operator.largerEqualThan, number);
                }
                return DStarRunner.testNumericCondition(value, operator.largerThan, number);
            }
            if (conditionString.startsWith("=")) {
                String stringOrNumber = conditionString.substring(1);
                if (stringOrNumber.isEmpty()) {
                    return value instanceof BlankEval;
                }
                boolean itsANumber = false;
                try {
                    Integer.parseInt(stringOrNumber);
                    itsANumber = true;
                }
                catch (NumberFormatException e) {
                    try {
                        Double.parseDouble(stringOrNumber);
                        itsANumber = true;
                    }
                    catch (NumberFormatException e2) {
                        itsANumber = false;
                    }
                }
                if (itsANumber) {
                    return DStarRunner.testNumericCondition(value, operator.equal, stringOrNumber);
                }
                String valueString = value instanceof BlankEval ? "" : DStarRunner.getStringFromValueEval(value);
                return stringOrNumber.equals(valueString);
            }
            if (conditionString.isEmpty()) {
                return value instanceof StringEval;
            }
            String valueString = value instanceof BlankEval ? "" : DStarRunner.getStringFromValueEval(value);
            return valueString.startsWith(conditionString);
        }
        if (condition instanceof NumericValueEval) {
            double conditionNumber = ((NumericValueEval)condition).getNumberValue();
            Double valueNumber = DStarRunner.getNumerFromValueEval(value);
            if (valueNumber == null) {
                return false;
            }
            return conditionNumber == valueNumber;
        }
        if (condition instanceof ErrorEval) {
            if (value instanceof ErrorEval) {
                return ((ErrorEval)condition).getErrorCode() == ((ErrorEval)value).getErrorCode();
            }
            return false;
        }
        return false;
    }

    private static boolean testNumericCondition(ValueEval valueEval, operator op, String condition) throws EvaluationException {
        if (!(valueEval instanceof NumericValueEval)) {
            return false;
        }
        double value = ((NumericValueEval)valueEval).getNumberValue();
        double conditionValue = 0.0;
        try {
            int intValue = Integer.parseInt(condition);
            conditionValue = intValue;
        }
        catch (NumberFormatException e) {
            try {
                conditionValue = Double.parseDouble(condition);
            }
            catch (NumberFormatException e2) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
        }
        int result = NumberComparer.compare(value, conditionValue);
        switch (op) {
            case largerThan: {
                return result > 0;
            }
            case largerEqualThan: {
                return result >= 0;
            }
            case smallerThan: {
                return result < 0;
            }
            case smallerEqualThan: {
                return result <= 0;
            }
            case equal: {
                return result == 0;
            }
        }
        return false;
    }

    private static Double getNumerFromValueEval(ValueEval value) {
        if (value instanceof NumericValueEval) {
            return ((NumericValueEval)value).getNumberValue();
        }
        if (value instanceof StringValueEval) {
            String stringValue = ((StringValueEval)value).getStringValue();
            try {
                return Double.parseDouble(stringValue);
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
        return null;
    }

    private static String getStringFromValueEval(ValueEval value) throws EvaluationException {
        if (!((value = DStarRunner.solveReference(value)) instanceof StringValueEval)) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return ((StringValueEval)value).getStringValue();
    }

    private static enum operator {
        largerThan,
        largerEqualThan,
        smallerThan,
        smallerEqualThan,
        equal;

    }

    public static enum DStarAlgorithmEnum {
        DGET,
        DMIN;

    }
}

