% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R
\name{evaluatorActions}
\alias{evaluatorActions}
\alias{serverAddToPath}
\alias{serverImport}
\alias{serverTask}
\title{Add to Table of Search Paths and Import Commands}
\usage{
serverAddToPath(Class, directory,
  package = utils::packageName(topenv(parent.frame())), pos = NA,
  onLoad = NA, where = topenv(parent.frame()))

serverImport(Class, ..., onLoad = nzchar(packageName(where)),
  where = topenv(parent.frame()))

serverTask(Class, command, onLoad = nzchar(packageName(where)),
  where = topenv(parent.frame()))
}
\arguments{
\item{Class}{the class of the server-specific evalutor.}

\item{directory}{the directory to add to the search path table.}

\item{package}{the name of the server-specific interface package.}

\item{pos}{where in the list of directories to insert this one.  Defaults to the end.}

\item{onLoad, where}{used to set up a load action; should be omitted if called from a package source}

\item{...}{arguments to pass to the evaluator's \code{$Import()} method}

\item{command}{an \emph{unevaluated} command or expression for the evaluator.}
}
\description{
Utilities to add to the table of search paths, import commands and tasks for all evalutors of the
specified class.  Called only from analogous functions in packages for specific languages.
}
\details{
The server-specific information is added to the table stored by the XR package.  All future
evaluators for the specified interface class will have these directories in their search
path, will import the module information specified and carry out any other tasks supplied.

If a current evaluator for this
class exists, it applies all the commands, but \emph{previous} evalutors
for this class are not modified.

Commands are evaluated in the order of the calls to these functions.  For example, the application
package should execute a call to add to the search path before any calls to import modules form
the corresponding directory.
}
\section{Functions}{
\itemize{
\item \code{serverAddToPath}: Add the directory to the search path of all evaluators of this class.

\item \code{serverImport}: An import command with these arguments will be executed for each new evaluator of this
interface class, and for the current evaluator if one exists.

\item \code{serverTask}: An unevalated command or expression for the interface is supplied, typically using
\code{quote()} or \code{substitute}.  When an evaluator from the class is created, this
command will be evaluated.
}}

\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 13, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}
