% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{analytics_request}
\alias{analytics_request}
\title{Analytics Request Function - YouTube Analytics API}
\usage{
analytics_request(
  dimensions = NULL,
  metrics = "views,estimatedMinutesWatched",
  sort = NULL,
  maxResults = 10,
  filters = NULL,
  startDate = "2000-01-01",
  endDate = as.character(Sys.Date()),
  ids = "channel==MINE",
  currency = NULL,
  startIndex = NULL,
  includeHistoricalChannelData = NULL,
  token = getOption("YouTube_Token")
)
}
\arguments{
\item{dimensions}{String. See \url{https://developers.google.com/youtube/analytics/dimensions}
for valid arguments.}

\item{metrics}{String. See \url{https://developers.google.com/youtube/analytics/metrics}
for valid arguments.}

\item{sort}{String. Specify by which metric/dimensions to sort output if applicable.}

\item{maxResults}{Integer. Specify the number of results to return. Maximum is 200.}

\item{filters}{String. Specify dimension to filter on if applicable. Ex: video==dQw4w9WgXcQ}

\item{startDate}{Required. String specifying start date.}

\item{endDate}{Required. String specifying end date.}

\item{ids}{Required. Specify the channel. By default the function will specify \code{"channel==MINE"}}

\item{currency}{String. Specify currency if applicable}

\item{startIndex}{Integer. Specify index of first entity to retrieve, if applicable.}

\item{includeHistoricalChannelData}{String. Indicates whether the API response should include
channels' watch time and view data from the time period prior
to when the channels were linked to the content owner. Only
applies to content owner reports. Either 'true' or 'false'.}

\item{token}{Required.}
}
\value{
data.frame
}
\description{
This is the function to make API calls to the YouTube Analytics API. Most other
functions in this package are wrappers for this function with some arguments already populated.
If none of the other prebuilt functions work for your use case, this is the function to turn to.
}
\examples{
\dontrun{
analytics_request(startDate = "2018-05-01",
                  endDate = "2017-01-01",
                  metrics = "views,comments,likes,dislikes,estimatedMinutesWatched")
}
}
