% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.projectedplant3d}
\alias{plot.projectedplant3d}
\alias{print.projectedplant3d}
\alias{projectplant}
\title{Project plant coordinates onto a viewing plane}
\usage{
\method{plot}{projectedplant3d}(x, silhouette = FALSE, xlim = NULL,
  ylim = NULL, leaffill = TRUE, leafcol = "forestgreen",
  zerocenter = FALSE, xlab = "X", ylab = "Y", ...)

\method{print}{projectedplant3d}(x, ...)

projectplant(plant, azimuth, altitude)
}
\arguments{
\item{x}{Object of class 'projectedplant3d'.}

\item{silhouette}{Add a 2D convex hull (see \code{\link{Silhouette}}).}

\item{xlim,ylim}{Limits for the X and Y axes.}

\item{leaffill}{If TRUE, fills leaves with green stuff.}

\item{leafcol}{If leaffill=TRUE, the color of the leaves.}

\item{zerocenter}{Whether to shift the plant to X=0 and Y=0.}

\item{xlab,ylab}{Labels for X and Y axes}

\item{plant}{Object of class 'plant3d' (see \code{\link{constructplant}}.}

\item{azimuth,altitude}{Azimuth and altitude from which plant is viewed.}

\item{\dots}{Further parameters passed to plot() (but ignored for print).}
}
\value{
Returns an object of class 'projectedplant3d', with components:

leaves - A list of matrices with the coordinates of the leaf edges.
Each matrix has columns VX,VY and VZ, which are the viewplane coordinates
(with the Z axis pointing toward the viewer).

viewbound - List of min and max values of coordinates (minx, maxx,
miny, etc.).

viewangle - Azimuth and altitude used for projection.
}
\description{
Transform all leaf edge coordinates onto a viewplane coordinate system, with the 'z' axis pointing toward the viewer.
}
\examples{
# View a plant from above.
# The 2D convex hull is also plotted (the 'silhouette'),
# and the area of the hull is printed on the graph.
topview <- projectplant(pilularis, altitude=90, azimuth=180)
plot(topview, leaffil=TRUE, silhouette=TRUE)
}
\author{
Remko Duursma
}
\seealso{
\code{\link{STARbar}}
}
\keyword{misc}

