\name{zim.control}
\alias{zim.control}
\title{Auxiliary for Controlling ZIM Fitting}
\usage{
zim.control(dist = c("zip", "zinb"), method = c("EM-NR", "EM-FS"),
  type = c("solve", "ginv"), robust = FALSE, trace = FALSE,
  start = NULL, minit = 10, maxit = 10000, epsilon = 1e-08)
}
\arguments{
  \item{dist}{count model family.}

  \item{method}{algorithm for parameter estimation.}

  \item{type}{type of matrix inverse.}

  \item{robust}{logical; if TRUE, robust standard errors
  will be calculated.}

  \item{trace}{logical; if TRUE, display iteration
  history.}

  \item{start}{initial parameter values.}

  \item{minit}{minimum number of iterations.}

  \item{maxit}{maximum number of iterations.}

  \item{epsilon}{positive convergence tolerance.}
}
\description{
Auxiliary function for \code{\link{zim}} fitting. Typically
only used internally by \code{\link{zim.fit}}, but may be
used to construct a control argument for either function.
}
\seealso{
\code{\link{zim}}, \code{\link{zim.fit}}
}
\keyword{regression}

