% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMZOIP.R
\name{RM.ZOIP}
\alias{RM.ZOIP}
\title{ZOIP regression with fixed efects}
\usage{
RM.ZOIP(formula.mu, formula.sigma = ~1, formula.p0 = ~1, formula.p1 = ~1,
  data, link = c("identity", "identity", "identity", "identity"),
  family = "R-S", optimizer = "nlminb")
}
\arguments{
\item{formula.mu}{Formula that defines the regression function for mu, p.e and ~ x1 + x2, it is necessary to define the response variable.}

\item{formula.sigma}{Formula that defines the regression function for the sigma parameter, a possible value is ~ x1, by default ~ 1.}

\item{formula.p0}{Formula that defines the regression function for p0, a possible value is ~ x1, by default ~ 1.}

\item{formula.p1}{Formula that defines the regression function for p1, a possible value is ~ x1, by default ~ 1.}

\item{data}{It is the data set in data.frame format where it must contain the names of the columns as they are in the formulas.}

\item{link}{It is a vector with the appropriate link functions for each parameter to be estimated according to the options chosen in the family and formula parameters. If the regression model does not have covariables, the identity option should be used as a link function, regardless of the value chosen in the family, possible options are logit, log, default link = c ('identity', 'identity', 'identity', 'identity').}

\item{family}{choice of the parameterization or distribution, family = 'R-S' parameterization beta distribution Rigby and Stasinopoulos, 'F-C' distribution Beta parametrization Ferrari and Cribari-Neto, 'Original' Beta distribution classic parameterization, 'Simplex' simplex distribution.}

\item{optimizer}{Choice of the optimizer, used to find the convergence of the maximum likelihood. you can choose the value of 'nlminb' or 'optim', by default 'nlminb'.}
}
\description{
The RM.ZOIP function adjusts a ZOIP regression model via maximum likelihood. the model may or may not include
covariables in any of its parameters, just as it can be a bilaterally inflated model, unilaterally or without parameters
of inflation
}
\examples{

#Test 1--------------------------------------------------
library(ZOIP)
library(boot)
library(numDeriv)
n<-1000
x1<-stats::runif(n)
x2<-stats::runif(n)

b1<-0.3
b2<--0.5
b3<-0.9
sigma_i<-exp(b1+b2*x1+b3*x2)

c1<-0.2
c2<--1
c3<-0.1
mu_i<-exp(c1+c2*x1)

d1<-0.07
p0_i<-rep(d1,length(n))

e1<-0.02
e2<--4
p1_i<-boot::inv.logit(e1+e2*x2)

param<-cbind(mu_i,sigma_i,p0_i,p1_i)

system.time(y_i<-apply(param,1,function(x){rZOIP(1,mu=x[1],sigma=x[2],
                                                 p0=x[3],p1=x[4],family='Original')}))
data<-as.data.frame(cbind(y_i,x1,x2))

formula.mu=y_i~x1
formula.sigma=~x1+x2
formula.p0=~1
formula.p1=~x2
link=c('log','log','identity','logit')
family='Original'
mod<-RM.ZOIP(formula.mu=formula.mu,formula.sigma=formula.sigma,formula.p0=formula.p0,
             formula.p1=formula.p1,data=data,link=link,family=family)
mod
summary(mod)


}
