% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nearPD}
\alias{nearPD}
\title{Nearest symmetric positive definite matrix}
\usage{
nearPD(K0)
}
\arguments{
\item{K0}{A square matrix}
}
\value{
The closest symmetric positive definite matrix to K0.
}
\description{
This function finds the nearest symmetric positive definite matrix to the given matrix.
It is used throughout the package to handle numerical issues in matrix inverses
and cholesky decompositions.
}
\references{
Higham, N. J. (1988). Computing a nearest symmetric positive semidefinite matrix. Linear Algebra and its Applications, 103, 103-118.

D'Errico, J. (2013). nearestSPD Matlab function. \url{https://uk.mathworks.com/matlabcentral/fileexchange/42885-nearestspd}.
}
\author{
Adapted from Matlab code by John D'Errico
}
