% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_polylines.R
\name{canvas_polylines}
\alias{canvas_polylines}
\title{Draw Polygons and Lines}
\usage{
canvas_polylines(colors, background = "#fafafa", ratio = 0.5, iterations = 1000,
                 size = 0.1, resolution = 500)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the lines.}

\item{ratio}{a positive value specifying the width of the polygons. Larger ratios cause more overlap.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{size}{a positive value specifying the size of the borders.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws many points on the canvas and connects these points into a polygon. After repeating this for all the colors, the edges of all polygons are drawn on top of the artwork.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_polylines(colors = colorPalette("retro1"))
}

}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
