% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_function.R
\name{canvas_function}
\alias{canvas_function}
\title{Draw Functions}
\usage{
canvas_function(
  colors,
  background = "#fafafa",
  by = 0.01,
  polar = TRUE,
  formula = NULL
)
}
\arguments{
\item{colors}{a string specifying the color used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{by}{a value specifying the step size between consecutive points.}

\item{polar}{logical. Whether to draw the function with polar coordinates.}

\item{formula}{optional, a named list with 'x' and 'y' as structured in the example. If \code{NULL} (default), chooses a function with random parameters.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints functions with random parameters on a canvas.
}
\examples{
\donttest{
set.seed(10)

# Simple example
canvas_function(colors = colorPalette("tuscany1"))

# Advanced example
formula <- list(
  x = quote(x_i^2 - sin(y_i^2)),
  y = quote(y_i^3 - cos(x_i^2))
)
canvas_function(colors = "firebrick", formula = formula)
}

}
\references{
\url{https://github.com/cutterkom/generativeart}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
