% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aSPUpath.r
\name{aSPUpath}
\alias{aSPUpath}
\title{Pathway based Sum of Powered Score tests (SPUpath) and adaptive SPUpath (aSPUpath) test for single trait - pathway association.}
\usage{
aSPUpath(
  Y,
  X,
  cov = NULL,
  model = c("binomial", "gaussian"),
  snp.info,
  gene.info,
  pow = c(1:8, Inf),
  pow2 = c(1, 2, 4, 8),
  n.perm = 200,
  usePCs = F,
  varprop = 0.95
)
}
\arguments{
\item{Y}{Response or phenotype data. It can be a disease indicator; =0 for controls, =1 for cases.
Or it can be a quantitative trait. A vector with length n (number of observations).}

\item{X}{Genotype or other data; each row for a subject, and each column
for an SNP (or a predictor). The value of each SNP is the # of the copies
for an allele. A matrix with dimension n by k (n : number of observation, k : number of SNPs (or predictors) ).}

\item{cov}{Covariates. A matrix with dimension n by p (n :number of observation, p : number of covariates).}

\item{model}{Use "gaussian" for a quantitative trait, and use "binomial" for a binary trait.}

\item{snp.info}{SNP information matrix, the 1st column is SNP id, 2nd column is chromosome #, 3rd column indicates SNP location.}

\item{gene.info}{GENE information matrix, The 1st column is GENE id, 2nd column is chromosome #, 3rd and 4th column indicate start and end positions of the gene.}

\item{pow}{SNP specific power(gamma values) used in SPUpath test.}

\item{pow2}{GENE specific power(gamma values) used in SPUpath test.}

\item{n.perm}{number of permutations.}

\item{usePCs}{indicating whether to extract PCs and then use PCs of X.}

\item{varprop}{the proportion of the variations explained (cutoff) that
determines how many top PCs to use.}
}
\value{
P-values for SPUpath tests and aSPUpath test.
}
\description{
It gives p-values of the SPUpath tests and aSPUpath test.
}
\examples{

\dontrun{dat1<-simPathAR1Snp(nGenes=20, nGenes1=5, nSNPlim=c(1, 20),
	       nSNP0=1, LOR=.2, n=100, MAFlim=c(0.05, 0.4), p0=0.05 ) }
\dontshow{dat1<-simPathAR1Snp(nGenes=20, nGenes1=5, nSNPlim=c(1, 20),
            nSNP0=1, LOR=.2, n=40, MAFlim=c(0.05, 0.4), p0=0.05 ) }

# p-values of SPUpath and aSPUpath tests.
\dontrun{p.pathaspu<- aSPUpath(dat1$Y, dat1$X, snp.info = dat1$snp.info,
         gene.info = dat1$gene.info,
         model = "binomial", pow=1:8, pow2=c(1, 2, 4, 8), n.perm=1000) }
\dontshow{p.pathaspu<- aSPUpath(dat1$Y, dat1$X, snp.info = dat1$snp.info,
         gene.info = dat1$gene.info,
         model = "binomial", pow=1:8, pow2=c(1, 2, 4, 8), n.perm=30) }
p.pathaspu
## pow = 1:8 and pow2 = 1,2,4,8
## So, there are 8*4 = 32 SPUpath p-values.
## SPUpathi,j corresponds pow = i , pow2 = j
## The last element, aSPUpath gives aSPUpath p-value.

}
\references{
Wei Pan, Il-Youp Kwak and Peng Wei (2015)
A Powerful and Pathway-Based Adaptive Test for Genetic Association With Common or Rare Variants, The American Journal of Human Genetics, 97, 86-98
}
\seealso{
\code{\link{simPathAR1Snp}}
}
\author{
Il-Youp Kwak and Wei Pan
}
