% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba_utils.R
\name{set_data}
\alias{set_data}
\title{Set the data of an aba model}
\usage{
set_data(model, data)
}
\arguments{
\item{model}{an aba model. The model on which data will be set.}

\item{data}{dataframe or tibble. The data to set.}
}
\value{
An aba model with data set.
}
\description{
The raw data will be used to fit all of the statistical models. This data
will be processed according to what is specified in the aba stat objects.
}
\examples{

data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# set data in the traditional way
model <- aba_model() \%>\% set_data(data)

# pipe data into an `aba_model()` call to get access to auto-completion on
# variables from RStudio upon further pipes. This is useful for setting
# other specs because it will reduce the chance of typos on variable names.
model <- data \%>\% aba_model()

}
