% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{createAbnDag}
\alias{createAbnDag}
\title{Make DAG of class "abnDag"}
\usage{
createAbnDag( dag, data.df = NULL, data.dists = NULL, ...)
}
\arguments{
\item{dag}{a matrix or a formula specifying a DAG, see \sQuote{Details}.}

\item{data.df}{named dataframe.}

\item{data.dists}{named list giving the distribution for each node in the network. If not provided it will be sample and returned.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
abnDag object as list of dag, data.df, data.dists.

Create a legitimate DAGs

Create a legitimate DAG in the abn format.

An object of class \code{abnDag} containing a named matrix and a named list giving the distribution for each node.
}
\description{
Make DAG of class "abnDag"
}
\details{
An object of class \code{class(abnDag)} contains a named matrix describing the DAG and possibly additional objects such as the associated distributions of the nodes.
If the dag is specified with a formula, either \code{data.df} or \code{data.dists} is required with the \code{.} quantifier.
If the dag is specified with an unnamed matrix and both \code{data.df} and \code{data.dists} are missing,  lower-case letters of the Roman alphabet are used for the node names.
}
\examples{
dagFromFormula <- createAbnDag(dag = ~a+b|a,
                              data.df = data.frame("a"=1, "b"=1),
                              data.dists = list(a="binomial", b="gaussian"))
dagFromMatrix <- createAbnDag(dag = matrix(c(0,1,0,0), 2, 2),
                              data.df = data.frame("a"=1, "b"=1),
                              data.dists = list(a="binomial", b="gaussian"))
plot(dagFromMatrix)

}
\concept{DAG}
\keyword{internal}
\keyword{utilities}
