% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_ZVD.R
\name{test_ZVD}
\alias{test_ZVD}
\title{Classify test data using nearest centroid classification and
discriminant vectors learned from the training set.}
\usage{
test_ZVD(w, test, classMeans, mus, scaling, ztol)
}
\arguments{
\item{w}{Matrix with columns equal to discriminant vectors.}

\item{test}{matrix containing test set.}

\item{classMeans}{Means of each class in the training set,
(used for computing centroids for classification).}

\item{mus}{means/standard devs of the training set,
(used for centering/normalizing the test data appropriately).}

\item{scaling}{Logical indicating whether scaling should be done.
on the test set.}

\item{ztol}{Threshold for setting values in DVs to zero.}
}
\value{
\code{test_ZVD} returns an object of \code{\link{class}} "\code{test_ZVD}" including a list
with the following named components

\describe{
  \item{\code{stats}}{list containing number of misclassified observations,
  l0 and l1 norms of discriminants.}
  \item{\code{pred_labs}}{predicted class labels according to nearest centroid
  and the discriminants.}
}
}
\description{
This function is used in SZVDcv and is only meant for internal
use at this stage. Will potentially be released in future versions.
}
\details{
This function is used by other functions and should only be called explicitly for
debugging purposes. Potential release in the future.
This function should potentially be made internal for the release.
}
\seealso{
Used by: \code{\link{SZVDcv}}.
}
\keyword{internal}
