% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_load.R
\name{corpus_load}
\alias{corpus_load}
\title{Load annotation files into corpus object}
\usage{
corpus_load(x, createFullText = TRUE, assignMedia = TRUE)
}
\arguments{
\item{x}{Corpus object.}

\item{createFullText}{Logical; if \code{TRUE} full text will be created.}

\item{assignMedia}{Logical; if \code{TRUE} the folder(s) specified in \code{@folders.media} of your corpus object will be scanned for media.}
}
\value{
Corpus object.
}
\description{
Scans all folders specified in if \code{x@folders.annotationfiles} for annotation files an loads them as transcript objects into the corpus object. 
All prior transcript objects will be removed.
}
\examples{
library(act)

# The example files that come with the act library are located here:
path <- system.file("extdata", "examplecorpus", package="act")

# This is the examplecorpus object that comes with the library
examplecorpus

# Make sure that the input folder of the example corpus object is set correctly
examplecorpus@folders.annotationfiles <- path
examplecorpus@folders.media <- path

# Load annotation files into the corpus object (again)
examplecorpus <- act::corpus_load(x=examplecorpus)

# Creating the full texts may take a long time.
# If you do not want to create the full texts immediately use the following command:
examplecorpus <- act::corpus_load(x=examplecorpus, createFullText=FALSE )
}
\seealso{
\link{corpus_new}, \link{examplecorpus}
}
