% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_srt.R
\name{export_srt}
\alias{export_srt}
\title{Export a transcript object to a .srt subtitle file}
\usage{
export_srt(
  t,
  outputPath = NULL,
  filterTierNames = NULL,
  filterSectionStartsec = NULL,
  filterSectionEndsec = NULL,
  speaker.show = TRUE,
  speaker.width = 3,
  speaker.ending = ":"
)
}
\arguments{
\item{t}{Transcript object; transcript to be saved.}

\item{outputPath}{Character string; path where .srt will be saved.}

\item{filterTierNames}{Vector of character strings; names of tiers to be included. If left unspecified, all tiers will be exported.}

\item{filterSectionStartsec}{Double; start of selection in seconds.}

\item{filterSectionEndsec}{Double; end of selection in seconds.}

\item{speaker.show}{Logical; if \code{TRUE} name of speaker will be shown before the content of the annotation.}

\item{speaker.width}{Integer; width of speaker abbreviation, -1 for full name without shortening.}

\item{speaker.ending}{Character string; string that is added at the end of the speaker name.}
}
\value{
Contents of the .srt file (only if \code{outputPath} is left empty)
}
\description{
Advice: In most situations it is more convenient to use \code{act::corpus_export} for exporting annotation files.
}
\details{
Creates a 'Subrip title' .srt subtitle file.
It will be written to the file specified in \code{outputPath}.
If \code{outputPath} is left empty, the function will return the contents of the .srt itself.
}
\examples{
library(act)

# Get the transcript you want to export
t <- examplecorpus@transcripts[[1]]

# Create temporary file path
path <- tempfile(pattern = t@name, tmpdir = tempdir(),
                 fileext = ".srt")

# It makes more sense, however, to you define a destination folder
# that is easier to access on your computer:
\dontrun{
path <- file.path("PATH_TO_AN_EXISTING_FOLDER_ON_YOUR_COMPUTER",
                    paste(t@name, ".srt", sep=""))
}

# Export
act::export_srt(t=t, outputPath=path)

}
\seealso{
\code{corpus_export}, \code{export_eaf}, \code{export_exb}, \code{export_printtranscript}, \code{export_rpraat}, \code{export_textgrid}
}
