% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkInactiveness}
\alias{checkInactiveness}
\title{Find if a tag is standing still in an array}
\usage{
checkInactiveness(
  movements,
  tag,
  detections,
  n,
  inactive.warning,
  inactive.error,
  dist.mat,
  GUI,
  save.tables.locally
)
}
\arguments{
\item{movements}{The movements table for a specific tag.}

\item{tag}{The tag being analysed.}

\item{detections}{The detections data.frame for a specific tag.}

\item{n}{A string indicating the overall progress.}

\item{inactive.warning}{If a tag spends a number of days equal or greater
than \code{inactive.warning} in a given array at the tail of the respective
detections, a warning is issued. If left NULL (default), no warnings are
issued.}

\item{inactive.error}{If a tag spends a number of days equal or greater than
\code{inactive.error} in a given array at the tail of the respective
detections, user intervention is suggested. If left NULL (default), user
intervention is never suggested.}

\item{dist.mat}{A distances matrix.}

\item{GUI}{One of "needed", "always" or "never". If "needed", a new window is
opened to inspect the movements only if the movements table is too big to be
displayed in R's console. If "always", a graphical interface is always created
when the possibility to invalidate events emerges. If "never", a graphical
interface is never invoked. In this case, if the table to be displayed does
not fit in R's console, a temporary file will be saved and the user will be
prompted to open and examine that file. Defaults to "needed".}

\item{save.tables.locally}{Logical: If a table must be temporarily stored into a file
for user inspection, should it be saved in the current working directory, or
in R's temporary folder?}
}
\value{
A list of movements with updated 'Valid' columns
}
\description{
Find if a tag is standing still in an array
}
\keyword{internal}
