
# activAnalyzer

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/activAnalyzer)](https://CRAN.R-project.org/package=activAnalyzer)
[![Codecov test
coverage](https://codecov.io/gh/pydemull/activAnalyzer/branch/master/graph/badge.svg)](https://app.codecov.io/gh/pydemull/activAnalyzer?branch=master)
[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
[![R-CMD-check](https://github.com/pydemull/activAnalyzer/workflows/R-CMD-check/badge.svg)](https://github.com/pydemull/activAnalyzer/actions)
[![](http://cranlogs.r-pkg.org/badges/grand-total/activAnalyzer?color=blue)](https://cran.r-project.org/package=activAnalyzer)
[![status](https://joss.theoj.org/papers/5d6659af1bf8ca2fb977c189039b8315/status.svg)](https://joss.theoj.org/papers/10.21105/joss.04741)
<!-- badges: end -->

activAnalyzer is a Shiny app that has been developed to analyze daily
physical behavior data recorded at the hip in adults using an ActiGraph
accelerometer (.agd files). Once analysis is completed, the app allows
exporting results to .csv files and generating a report of the
measurement (in either an .html format or a .pdf format). All the
configured inputs relevant for interpreting the results are recorded in
the report. Be sure that the inputs that are configured when generating
the report correspond to the analysis that was actually performed (in
other words, avoid modifying the inputs after generating satisfactory
results). In addition to an analysis of physical behavior, the app also
allows to implement the [Daily- and Clinical visit-PROactive Physical
Activity in COPD (chronic obstructive pulmonary disease) instruments
(D-PPAC and
C-PPAC)](https://erj.ersjournals.com/content/early/2015/05/28/09031936.00183014).
Please read the [user’s
guide](https://github.com/pydemull/activAnalyzer/blob/master/inst/guide/user_guide_en.pdf)
for details about how the app works.

## Usage

There are three different ways to use the activAnalyzer app:

- [On the web via a shinyapps.io
  platform](https://pydemull.shinyapps.io/activAnalyzer/) (stable
  version). For information, as indicated by
  [RStudio](https://www.shinyapps.io/), “*shinyapps.io is
  secure-by-design. Each Shiny application runs in its own protected
  environment and access is always SSL encrypted*”. Importantly, the app
  is hosted using a free account that allows to run apps for 25 hours
  per month. Thus, the availability of the app on the web is very
  dependent on the number of users as well as the time spent by each
  user on the app. Moreover, as computations when using the app can be
  quite intensive, it is possible that speed and stability of this
  online version of the app become sometimes compromised. For these
  reasons, this option should be considered as a way to have a quick
  look at how the app works. The other available options (please see
  below) will be more appropriate for working with the app on a regular
  basis. Of note, Google Chrome and Microsoft Edge browsers allow the
  app to work as expected but Mozilla Firefox does not seem to allow
  resetting all the inputs when required.
- [On your machine via a standalone desktop
  app](https://sourceforge.net/projects/activanalyzer) that is
  downloadable from the SourceForge website (stable version, for Windows
  machines only). The standalone app has been developed using the
  framework *DesktopDeployR* made available by [W. Lee
  Pang](https://github.com/wleepang). Explanations related to this
  framework can be retrieved from [a dedicated GitHub
  repository](https://github.com/wleepang/DesktopDeployR). Once the app
  is installed on your PC, you will have to double-click on the desktop
  app icon (if you chose this option during the installation process),
  which will run the R-portable version embedded in the app and then
  will launch the app in your default web browser with 127.0.0.1 as the
  value for the host parameter. This means that only your current
  machine will can access the app. You will can open only one session at
  a time. As written above, Google Chrome and Microsoft Edge browsers
  allow the app to work as expected but Mozilla Firefox does not seem to
  allow resetting all the inputs when required.
- On your machine via [R software](https://CRAN.R-project.org/)
  (version: $\ge$ 3.4.0), the [RStudio environment](https://posit.co/)
  (recommended version: Prairie Trillium \[2022.02\]; **Elsbeth Geranium
  \[2022-12\] does not allow to correctly quit the app from the RStudio
  window**), and the [activAnalyzer
  package](https://github.com/pydemull/activAnalyzer) installable from
  CRAN (stable version) or from GitHub (development version). To be able
  to generate a .pdf report, you will have to install the [TinyTeX
  distribution](https://yihui.org/tinytex/). The first time you will
  generate a .pdf report, you will have to wait some time so that the
  required packages are installed on your machine. In short, after
  installing R and RStudio, you can run the following command lines in
  the RStudio console:

``` r
# For CRAN version:

## Code for installing the activAnalyzer package (stable version)
install.packages("activAnalyzer")

## Code for installing the TinyTex distribution
install.packages("tinytex")
tinytex::install_tinytex()
```

``` r
# For development version:

## Code for installing the activAnalyzer package (development version)
install.packages("devtools")
devtools::install_github("pydemull/activAnalyzer")

## Code for installing the TinyTex distribution
install.packages("tinytex")
tinytex::install_tinytex()
```

## Example

To launch the app using R:

``` r
library(activAnalyzer)
activAnalyzer::run_app()
```

## Code of Conduct

Please note that the activAnalyzer project is released with a
[Contributor Code of
Conduct](https://pydemull.github.io/activAnalyzer/CODE_OF_CONDUCT.html).
By contributing to this project, you agree to abide by its terms.
