% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{compareAct}
\alias{compareAct}
\title{Compare activity level estimates}
\usage{
compareAct(fits)
}
\arguments{
\item{fits}{A list of fitted \code{actmod} objects}
}
\value{
A matrix with 4 columns: 1. differences between estimates; 2. SEs of the differences; 3. Wald statistics; 4. p-values (H0 is no difference between estimates). Matrix rows give all possible pairwise comparisons, numbered in the order in which they entered in the list \code{fits}.
}
\description{
Wald test for the statistical difference between two or more activitiy level estimates.
}
\details{
Uses a Wald test to ask whether the difference between estimates a1 and a2 is
significantly different from 0: statistic W = (a1-a2)^2 / (SE1^2+SE2^2) tested
on chi-sq distribution with 1 degree of freedom.
}
\examples{
#Test whether paca have a sigificantly different activity level from rat.
#Bootstrap reps limited to speed up example.
data(BCItime)
tPaca <- 2*pi*BCItime$time[BCItime$species=="ocelot"]
tRat <- 2*pi*BCItime$time[BCItime$species=="rat"]
fPaca <- fitact(tPaca, sample="data", reps=10)
fRat <- fitact(tRat, sample="data", reps=10)
fPaca@act
fRat@act
compareAct(list(fPaca,fRat))
}
