% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cadea.R
\name{cadea}
\alias{cadea}
\title{Make a constrained ADEA analysis}
\usage{
cadea(
  input,
  output,
  orientation = c("input", "output"),
  load.orientation = c("inoutput", "input", "output"),
  name = "",
  load.min,
  load.max,
  eff.tolerance = 1e-04
)
}
\arguments{
\item{input}{A matrix or a data frame with the inputs of units to be evaluated, one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame with the outputs of units to be evaluated, one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or use "output" for output orientation in DEA model.}

\item{load.orientation}{It allows the selection of variables to be included in load analysis.
Its default value is "inoutput" which means that all input and all output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}

\item{name}{An optional descriptive name for the model. It will be shown in print and summary results.}

\item{load.min}{A numeric value or vector giving minimum values for loads.
Values for \code{load.min} must belongs to [0, 1).}

\item{load.max}{A numeric value or vector giving maximum values for loads.
Values for \code{load.max} must be greater than 1.
If \code{load.min} or \code{load.max} are vectors then its length must be the same as the number of loads to compute.
This means, number of inputs when \code{load.orientation} is input, number of outputs when \code{load.orientation} is output, and the sum of both when \code{load.orientation} is inoutput.}

\item{eff.tolerance}{A value between 0 and 1 to tolerance when considering a DMU as efficient in reports.}
}
\value{
The function returns an object with efficiency scores, one set of weights for inputs and other for outputs, number of efficient units, load ratios and load levels.
}
\description{
This function computes an efficiency score for each DMU and a load for each variable in the current model.
But loads or contributions of input or output variables are constrained between the given values.
So DMU's efficiencies could change from regular DEA or ADEA model.
}
\details{
A variable load is a number between 0 and 1.
Where 0 means that the contribution of that variable to the efficiency computations is negligible.
In an ideal case, each input or output variable will have a load of 1 divide by the number of them.
This model force input and output weights in such a way that final variable loads fall between the given values.

For more information about loads or ADEA model see \code{\link{adea}}
}
\note{
If the given limits are too narrow, then the model is infeasible, which will result in an error.
}
\examples{
data('cardealers4')
input <- cardealers4[, 1:2]
output <- cardealers4[, 3:4]

# Compute adea model
model <- adea(input, output)
model
# Dealer A  Dealer B  Dealer C  Dealer D  Dealer E  Dealer F
# 0.9915929 1.0000000 0.8928571 0.8653846 1.0000000 0.6515044

# Get model load ratios
model$load$ratios
# $input
# Employees Depreciation
# 0.6666667    1.3333333
# $output
#  CarsSold WorkOrders
# 1.2663476  0.7336524 

# Compute a constrained adea model to force load between .8 and 1.5
cmodel <- cadea(input, output, load.min = .8, load.max = 1.5)
cmodel
# Dealer A  Dealer B  Dealer C  Dealer D  Dealer E  Dealer F
# 0.9915929 1.0000000 0.8928571 0.8653846 1.0000000 0.6515044

# Get model load ratios
cmodel$load$ratios
# $input
# Employees Depreciation
#       0.8          1.2
# $output
# CarsSold WorkOrders
#      1.2        0.8 

# See differences of efficiencies in both models
model$eff - cmodel$eff
#      Dealer A      Dealer B      Dealer C      Dealer D      Dealer E      Dealer F
# -2.220446e-16  0.000000e+00  0.000000e+00  0.000000e+00  0.000000e+00  5.942183e-02 
}
\seealso{
\code{\link{adea-package}}.
}
