% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dea.R
\name{dea}
\alias{dea}
\title{DEA - Data Envelopment Analysis}
\usage{
dea(
  input,
  output,
  orientation = c("input", "output"),
  name = "",
  solver = "auto"
)
}
\arguments{
\item{input}{A matrix or a data frame containing the inputs of the units to be evaluated, with one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame containing the outputs of the units to be evaluated, with one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or "output" for output orientation in DEA model.
The default is "input".}

\item{name}{An optional descriptive name for the model.
The default is an empty string. 
This name will be displayed in printed and summarized results.}

\item{solver}{The solver used by ROI to solve the DEA optimization problem.
The default is "auto."
The solver must be installed and capable of solving linear programming problems. 
Use \code{ROI_installed_solvers()} to list them.}
}
\value{
This function return a dea class object with the following named members:
\itemize{
\item name: A label of the model
\item orientation: DEA model orientation 'input' or 'output'
\item inputnames: Variable input names
\item outputnames: Variable output names
\item eff: is a vector with DMU's scores
\item ux: A set of weights for inputs
\item vy: A set of weights for output
\item vinput: Standardized virtual input dividing by the sum of the weights, see [Costa2006] in \code{\link{adea-package}}.
\item voutput: Standardized virtual output dividing by the sum of the weights, see [Costa2006] in \code{\link{adea-package}}
\item solver: The solver used for the resolution of the optimization problem
}
}
\description{
Data Envelopment Analysis, DEA, computes, for a set of Decision Making Units, DMU, a relative efficiency score, comparing one unit with the others.
}
\details{
Each DMU transforms inputs into outputs.
The set of inputs and outputs is the same for all the DMUs, but not their quantities.

This function computes a relative efficiency score and weights for each input and output variable in the model.
All these for each DMU.
}
\examples{
# Load data
data('cardealers4')

# Define input and output
input <- cardealers4[, c('Employees', 'Depreciation')]
output <- cardealers4[, c('CarsSold', 'WorkOrders')]

# Compute dea model
model <- dea(input, output, name = 'DEA for cardealers4 dataset')

# Print DMU efficiencies
model
# Dealer A  Dealer B  Dealer C  Dealer D  Dealer E  Dealer F
# 0.9915929 1.0000000 0.8928571 0.8653846 1.0000000 0.6515044

# Summarize the model and print aditional information
summary(model)
# Model name   DEA for cardealers4 dataset
# Orientation                        input
# Inputs            Employees Depreciation
# Outputs              CarsSold WorkOrders
# nInputs                                2
# nOutputs                               2
# nVariables                             4
# nEfficients                            2
# Eff. Mean               0.90022318389575
# Eff. sd                0.135194867030839
# Eff. Min.              0.651504424778761
# Eff. 1st Qu.           0.872252747252747
# Eff. Median            0.942225031605562
# Eff. 3rd Qu.           0.997898230088496
# Eff. Max.                              1

}
\seealso{
\code{\link{adea-package}}.
}
\concept{Data Envelopment Analysis}
\keyword{DEA}
