% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi_build_adea.R
\name{roi_build_adea}
\alias{roi_build_adea}
\title{Build adea problem}
\usage{
roi_build_adea(
  input,
  output,
  eff = NULL,
  orientation = c("input", "output"),
  load.orientation = c("inoutput", "input", "output"),
  solver = "auto",
  lp = NULL
)
}
\arguments{
\item{input}{A matrix or a data frame containing the inputs of the units to be evaluated, with one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame containing the outputs of the units to be evaluated, with one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or "output" for output orientation in DEA model.
The default is "input".}

\item{load.orientation}{This parameter allows the selection of variables to be included in load analysis. 
The default is "inoutput" which means that all input and output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}

\item{solver}{The solver used by ROI to solve the DEA optimization problem.
The default is "auto."
The solver must be installed and capable of solving linear programming problems. 
Use \code{ROI_installed_solvers()} to list them.}
}
\value{
lp
}
\description{
For the given input and output build the adea problem and return it.
}
\details{
Note: As this function is mainly for internal use, to avoid unnecessary overload, it does not do an extensive check of the input parameters. Use the higher level adea function instead.
}
\keyword{internal}
