% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward.sel.par.R
\name{forward.sel.par}
\alias{forward.sel.par}
\title{Parametric forward selection of explanatory variables in regression and RDA}
\usage{
forward.sel.par(Y, X, alpha = 0.05, K = nrow(X) - 1, R2thresh = 0.99,
  R2more = 0.001, adjR2thresh = 0.99, Yscale = FALSE, verbose = TRUE)
}
\arguments{
\item{Y}{Response data matrix with n rows and m columns containing 
quantitative variables}

\item{X}{Explanatory data matrix with n rows and p columns containing 
quantitative variables}

\item{alpha}{Significance level. Stop the forward selection procedure if the 
p-value of a variable is higher than alpha. The default is 0.05}

\item{K}{Maximum number of variables to be selected. The default is one minus
the number of rows}

\item{R2thresh}{Stop the forward selection procedure if the R-square of the 
model exceeds the stated value. This parameter can vary from 0.001 to 1}

\item{R2more}{Stop the forward selection procedure if the difference in model
R-square with the previous step is lower than R2more. The default setting 
is 0.001}

\item{adjR2thresh}{Stop the forward selection procedure if the adjusted 
R-square of the model exceeds the stated value. This parameter can take any
value (positive or negative) smaller than 1}

\item{Yscale}{Standardize the variables in table Y to variance 1. The default
setting is FALSE. The setting is automatically changed to TRUE if Y 
contains more than one variable. This is a validity condition for the 
parametric test of significance (Miller and Farr 1971)}

\item{verbose}{If 'TRUE' more diagnostics are printed. The default setting is
TRUE}
}
\value{
A dataframe with: \item{ variables }{ The names of the variables } 
  \item{ order }{ The order of the selection of the variables } \item{ R2 }{ 
  The R2 of the variable selected } \item{ R2Cum }{ The cumulative R2 of the 
  variables selected } \item{ AdjR2Cum }{ The cumulative adjusted R2 of the 
  variables selected } \item{ F }{ The F statistic } \item{ pval }{ The 
  P-value statistic }
}
\description{
If Y is univariate, this function implements FS in regression. If Y is 
multivariate, this function implements FS using the F-test described by 
Miller and Farr (1971). This test requires that (i) the Y variables be 
standardized, and (ii) the error in the response variables be normally 
distributed (to be verified by the user).
}
\details{
The forward selection will stop when either K, R2tresh, adjR2tresh, alpha and
R2more has its parameter reached.
}
\examples{

x <- matrix(rnorm(30),10,3)
y <- matrix(rnorm(50),10,5)
    
forward.sel.par(y,x, alpha = 0.5)
 
}
\author{
Pierre Legendre \email{pierre.legendre@umontreal.ca} and Guillaume 
  Blanchet
}
\references{
Miller, J. K. & S. D. Farr. 1971. Bimultivariate redundancy: a
  comprehensive measure of interbattery relationship. \emph{Multivariate
  Behavioral Research}, \bold{6}, 313--324.\cr
}
\keyword{multivariate}

