% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03amigaBlockBasics.r
\docType{methods}
\name{amigaBlock-method}
\alias{amigaBlock-method}
\alias{amigaBlock,amigaDisk,numeric-method}
\alias{amigaBlock<-}
\alias{amigaBlock<-,amigaDisk,numeric,amigaBlock-method}
\title{Extract block from or replace a block on an amigaDisk object}
\usage{
\S4method{amigaBlock}{amigaDisk,numeric}(x, block)

\S4method{amigaBlock}{amigaDisk,numeric,amigaBlock}(x, block) <- value
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} object from which the block needs to
be extracted or on which the block needs to be replaced.}

\item{block}{A \code{numeric} identifier (whole numbers
ranging from 0 up to 1759 (DD disk) or 3519 (HD disk)).}

\item{value}{An \code{\link{amigaBlock}} object with which the block
at the specified location on the disk needs to be replaced.}
}
\value{
The \code{\link{amigaBlock}} object at the specified location
is returned. In case of the replace method, an \code{\link{amigaDisk}}
object with a replaced \code{\link{amigaBlock}} is returned.
}
\description{
Extract an \code{\link{amigaBlock}} from an \code{\link{amigaDisk}} object,
or replace it on the disk.
}
\details{
Information is stored in 512 byte blocks on floppy disks. This method
extracts a specific block at a \code{numeric} identifier (whole numbers
ranging from 0 up to 1759 (DD disk) or 3519 (HD disk)) from an
\code{\link{amigaDisk}} object.
}
\examples{
## get the root block from the example adf:
amigaBlock(adf.example, 880)

## Create a completely blank disk without file system:
blank.disk <- new("amigaDisk")

## Replace the boot block on the blank disk with
## that from the example object:
amigaBlock(blank.disk, 0) <- amigaBlock(adf.example, 0)

## The blank disk now has a boot block,
## but still no file system...
}
\seealso{
Other block.operations: 
\code{\link{get.blockID}()},
\code{\link{get.diskLocation}()}
}
\author{
Pepijn de Vries
}
\concept{block.operations}
