% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_joined_exist_flag.R
\name{derive_var_confirmation_flag}
\alias{derive_var_confirmation_flag}
\title{Derive Confirmation Flag}
\usage{
derive_var_confirmation_flag(
  dataset,
  by_vars,
  order,
  new_var,
  tmp_obs_nr_var = NULL,
  join_vars,
  join_type,
  first_cond = NULL,
  filter,
  true_value = "Y",
  false_value = NA_character_,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} and \code{join_vars} parameter are
expected.}

\item{by_vars}{By variables

The specified variables are used as by variables for joining the input
dataset with itself.}

\item{order}{Order

The observations are ordered by the specified order.}

\item{new_var}{New variable

The specified variable is added to the input dataset.}

\item{tmp_obs_nr_var}{Temporary observation number

The specified variable is added to the input dataset and set to the
observation number with respect to \code{order}. For each by group (\code{by_vars})
the observation number starts with \code{1}. The variable can be used in the
conditions (\code{filter}, \code{first_cond}). It is not included in the output
dataset. It can be used to flag consecutive observations or the last
observation (see last example below).}

\item{join_vars}{Variables to keep from joined dataset

The variables needed from the other observations should be specified
for this parameter. The specified variables are added to the joined dataset
with suffix ".join". For example to flag all observations with \code{AVALC == "Y"} and \code{AVALC == "Y"} for at least one subsequent visit \code{join_vars = exprs(AVALC, AVISITN)} and \code{filter = AVALC == "Y" & AVALC.join == "Y" & AVISITN < AVISITN.join} could be specified.

The \verb{*.join} variables are not included in the output dataset.}

\item{join_type}{Observations to keep after joining

The argument determines which of the joined observations are kept with
respect to the original observation. For example, if \code{join_type = "after"}
is specified all observations after the original observations are kept.

For example for confirmed response or BOR in the oncology setting or
confirmed deterioration in questionnaires the confirmatory assessment must
be after the assessment to be flagged. Thus \code{join_type = "after"} could be
used.

Whereas, sometimes you might allow for confirmatory observations to occur
prior to the observation to be flagged. For example, to flag AEs occurring
on or after seven days before a COVID AE. Thus \code{join_type = "all"} could be
used.

\emph{Permitted Values:} \code{"before"}, \code{"after"}, \code{"all"}}

\item{first_cond}{Condition for selecting range of data

If this argument is specified, the other observations are restricted up to
the first observation where the specified condition is fulfilled. If the
condition is not fulfilled for any of the other observations, no
observations are considered, i.e., the observation is not flagged.

This parameter should be specified if \code{filter} contains summary functions
which should not apply to all observations but only up to the confirmation
assessment. For an example see the third example below.}

\item{filter}{Condition for selecting observations

The filter is applied to the joined dataset for flagging the confirmed
observations. The condition can include summary functions. The joined
dataset is grouped by the original observations. I.e., the summary function
are applied to all observations up to the confirmation observation. For
example, \code{filter = AVALC == "CR" & all(AVALC.join \%in\% c("CR", "NE")) & count_vals(var = AVALC.join, val = "NE") <= 1} selects observations with
response "CR" and for all observations up to the confirmation observation
the response is "CR" or "NE" and there is at most one "NE".}

\item{true_value}{Value of \code{new_var} for flagged observations

\emph{Default}: \code{"Y"}}

\item{false_value}{Value of \code{new_var} for observations not flagged

\emph{Default}: \code{NA_character_}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

\emph{Default:} \code{"warning"}

\emph{Permitted Values:} \code{"none"}, \code{"warning"}, \code{"error"}}
}
\value{
The input dataset with the variable specified by \code{new_var} added.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{derive_var_joined_exist_flag()} instead.
}
\details{
The following steps are performed to produce the output dataset.
\subsection{Step 1}{

The input dataset is joined with itself by the variables specified for
\code{by_vars}. From the right hand side of the join only the variables
specified for \code{join_vars} are kept. The suffix ".join" is added to these
variables.

For example, for \code{by_vars = USUBJID}, \code{join_vars = exprs(AVISITN, AVALC)} and input dataset

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# A tibble: 2 x 4
USUBJID AVISITN AVALC  AVAL
<chr>     <dbl> <chr> <dbl>
1             1 Y         1
1             2 N         0
}\if{html}{\out{</div>}}

the joined dataset is

\if{html}{\out{<div class="sourceCode r">}}\preformatted{A tibble: 4 x 6
USUBJID AVISITN AVALC  AVAL AVISITN.join AVALC.join
<chr>     <dbl> <chr> <dbl>        <dbl> <chr>
1             1 Y         1            1 Y
1             1 Y         1            2 N
1             2 N         0            1 Y
1             2 N         0            2 N
}\if{html}{\out{</div>}}
}

\subsection{Step 2}{

The joined dataset is restricted to observations with respect to
\code{join_type} and \code{order}.

The dataset from the example in the previous step with \code{join_type = "after"} and \code{order = exprs(AVISITN)} is restricted to

\if{html}{\out{<div class="sourceCode r">}}\preformatted{A tibble: 4 x 6
USUBJID AVISITN AVALC  AVAL AVISITN.join AVALC.join
<chr>     <dbl> <chr> <dbl>        <dbl> <chr>
1             1 Y         1            2 N
}\if{html}{\out{</div>}}
}

\subsection{Step 3}{

If \code{first_cond} is specified, for each observation of the input dataset the
joined dataset is restricted to observations up to the first observation
where \code{first_cond} is fulfilled (the observation fulfilling the condition
is included). If for an observation of the input dataset the condition is
not fulfilled, the observation is removed.
}

\subsection{Step 4}{

The joined dataset is grouped by the observations from the input dataset
and restricted to the observations fulfilling the condition specified by
\code{filter}.
}

\subsection{Step 5}{

The first observation of each group is selected
}

\subsection{Step 6}{

The variable specified by \code{new_var} is added to the input dataset. It is
set to \code{true_value} for all observations which were selected in the
previous step. For the other observations it is set to \code{false_value}.
}
}
\seealso{
Other deprecated: 
\code{\link{derive_param_extreme_event}()},
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_vars_last_dose}()}
}
\concept{deprecated}
\keyword{deprecated}
