% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_computed.R
\name{derive_derived_param}
\alias{derive_derived_param}
\title{Adds a Parameter Computed from the Analysis Value of Other Parameters}
\usage{
derive_derived_param(
  dataset,
  by_vars,
  parameters,
  analysis_value,
  set_values_to,
  filter = NULL,
  constant_by_vars = NULL,
  constant_parameters = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} parameter, \code{PARAMCD}, and \code{AVAL}
are expected.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of
the input dataset after restricting it by the filter condition (\code{filter}
parameter) and to the parameters specified by \code{parameters}.}

\item{by_vars}{Grouping variables

For each group defined by \code{by_vars} an observation is added to the output
dataset. Only variables specified in \code{by_vars} will be populated
in the newly created records.

\emph{Permitted Values:} list of variables}

\item{parameters}{Required parameter codes

It is expected that all parameter codes (\code{PARAMCD}) which are required to
derive the new parameter are specified for this parameter or the
\code{constant_parameters} parameter.

\emph{Permitted Values:} A character vector of \code{PARAMCD} values}

\item{analysis_value}{Definition of the analysis value

An expression defining the analysis value (\code{AVAL}) of the new parameter is
expected. The analysis values of the parameters specified by \code{parameters}
can be accessed using \verb{AVAL.<parameter code>}, e.g., \code{AVAL.SYSBP}.

\emph{Permitted Values:} An unquoted expression}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations. For example \code{vars(PARAMCD = "MAP")} defines the parameter
code for the new parameter.

\emph{Permitted Values:} List of variable-value pairs}

\item{filter}{Filter condition

The specified condition is applied to the input dataset before deriving the
new parameter, i.e., only observations fulfilling the condition are taken
into account.

\emph{Permitted Values:} a condition}

\item{constant_by_vars}{By variables for constant parameters

The constant parameters (parameters that are measured only once) are merged
to the other parameters using the specified variables. (Refer to Example 2)

\emph{Permitted Values:} list of variables}

\item{constant_parameters}{Required constant parameter codes

It is expected that all the parameter codes (\code{PARAMCD}) which are required
to derive the new parameter and are measured only once are specified here.
For example if BMI should be derived and height is measured only once while
weight is measured at each visit. Height could be specified in the
\code{constant_parameters} parameter. (Refer to Example 2)

\emph{Permitted Values:} A character vector of \code{PARAMCD} values}
}
\value{
The input dataset with the new parameter added. Note, a variable will only
be populated in the new parameter rows if it is specified in \code{by_vars}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is deprecated.  Please use \code{derive_param-computed()} instead.
}
\seealso{
Other deprecated: 
\code{\link{derive_var_aendy}()}
}
\author{
Stefan Bundfuss
}
\concept{deprecated}
\keyword{deprecated}
