% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_duration.R
\name{compute_duration}
\alias{compute_duration}
\title{Compute Duration}
\usage{
compute_duration(
  start_date,
  end_date,
  in_unit = "days",
  out_unit = "days",
  floor_in = TRUE,
  add_one = TRUE,
  trunc_out = FALSE
)
}
\arguments{
\item{start_date}{The start date

A date or date-time object is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.

Refer to \code{convert_dtc_to_dt()} to obtain a vector of imputed dates.}

\item{end_date}{The end date

A date or date-time object is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date
character vector to a date object.

Refer to \code{convert_dtc_to_dt()} to obtain a vector of imputed dates.}

\item{in_unit}{Input unit

See floor_in and add_one parameter for details.

Default: 'days'

Permitted Values: 'years', 'months', 'days', 'hours', 'minutes', 'seconds'}

\item{out_unit}{Output unit

The duration is derived in the specified unit

Default: 'days'

Permitted Values: 'years', 'months', 'weeks', 'days', 'hours', 'minutes',
'seconds'}

\item{floor_in}{Round down input dates?

The input dates are round down with respect to the input unit, e.g., if the
input unit is 'days', the time of the input dates is ignored.

Default: `TRUE``

Permitted Values: \code{TRUE}, \code{FALSE}}

\item{add_one}{Add one input unit?

If the duration is non-negative, one input unit is added. i.e., the
duration can not be zero.

Default: \code{TRUE}

Permitted Values: \code{TRUE}, \code{FALSE}}

\item{trunc_out}{Return integer part

The fractional part of the duration (in output unit) is removed, i.e., the
integer part is returned.

Default: \code{FALSE}

Permitted Values: \code{TRUE}, \code{FALSE}}
}
\value{
The duration between the two date in the specified unit
}
\description{
Compute duration between two dates, e.g., duration of an adverse event,
relative day, age, ...
}
\details{
The output is a numeric vector providing the duration as time from
start to end date in the specified unit. If the end date is before the start
date, the duration is negative.
}
\examples{
library(lubridate)

# Derive duration in days (integer), i.e., relative day
compute_duration(
  start_date = ymd_hms("2020-12-06T15:00:00"),
  end_date = ymd_hms("2020-12-24T08:15:00")
)

# Derive duration in days (float)
compute_duration(
  start_date = ymd_hms("2020-12-06T15:00:00"),
  end_date = ymd_hms("2020-12-24T08:15:00"),
  floor_in = FALSE,
  add_one = FALSE
)

# Derive age in years
compute_duration(
  start_date = ymd("1984-09-06"),
  end_date = ymd("2020-02-24"),
  trunc_out = TRUE,
  out_unit = "years",
  add_one = FALSE
)

# Derive duration in hours
compute_duration(
  start_date = ymd_hms("2020-12-06T9:00:00"),
  end_date = ymd_hms("2020-12-06T13:30:00"),
  out_unit = "hours",
  floor_in = FALSE,
  add_one = FALSE,
)
}
\seealso{
Date/Time Computation Functions that returns a vector: 
\code{\link{compute_dtf}()},
\code{\link{compute_tmf}()},
\code{\link{convert_date_to_dtm}()},
\code{\link{convert_dtc_to_dtm}()},
\code{\link{convert_dtc_to_dt}()},
\code{\link{impute_dtc_dtm}()},
\code{\link{impute_dtc_dt}()}
}
\author{
Stefan Bundfuss
}
\concept{com_date_time}
\keyword{com_date_time}
