% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_aage.R
\name{derive_vars_aage}
\alias{derive_vars_aage}
\title{Derive Analysis Age}
\usage{
derive_vars_aage(
  dataset,
  start_date = BRTHDT,
  end_date = RANDDT,
  age_unit = "YEARS",
  type = "interval"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{start_date} and \code{end_date} arguments are expected to be in the dataset.}

\item{start_date}{The start date

A date or date-time object is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date character
vector to a date object.

Default: \code{BRTHDT}}

\item{end_date}{The end date

A date or date-time object is expected.

Refer to \code{derive_vars_dt()} to impute and derive a date from a date character
vector to a date object.

Default: \code{RANDDT}}

\item{age_unit}{Age unit

The age is derived in the specified unit

Permitted Values (case-insensitive):

For years: \code{"year"}, \code{"years"}, \code{"yr"}, \code{"yrs"}, \code{"y"}

For months: \code{"month"}, \code{"months"}, \code{"mo"}, \code{"mos"}

For weeks: \code{"week"}, \code{"weeks"}, \code{"wk"}, \code{"wks"}, \code{"w"}

For days: \code{"day"}, \code{"days"}, \code{"d"}

For hours: \code{"hour"}, \code{"hours"}, \code{"hr"}, \code{"hrs"}, \code{"h"}

For minutes: \code{"minute"}, \code{"minutes"}, \code{"min"}, \code{"mins"}

For seconds: \code{"second"}, \code{"seconds"}, \code{"sec"}, \code{"secs"}, \code{"s"}}

\item{type}{lubridate duration type.

See below for details.

Default: \code{"duration"}

Permitted Values: \code{"duration"}, \code{"interval"}}
}
\value{
The input dataset with \code{AAGE} and \code{AAGEU} added
}
\description{
Derives analysis age (\code{AAGE}) and analysis age unit (\code{AAGEU}).

\strong{Note:} This is a wrapper function for the more generic \code{derive_vars_duration()}.
}
\details{
The duration is derived as time from start to end date in the
specified output unit. If the end date is before the start date, the duration
is negative. The start and end date variable must be present in the specified
input dataset.

The \href{https://lubridate.tidyverse.org/}{lubridate} package calculates two
types of spans between two dates: duration and interval.
While these calculations are largely the same, when the unit of the time period
is month or year the result can be slightly different.

The difference arises from the ambiguity in the length of \code{"1 month"} or
\code{"1 year"}.
Months may have 31, 30, 28, or 29 days, and years are 365 days and 366 during leap years.
Durations and intervals help solve the ambiguity in these measures.

The \strong{interval} between \code{2000-02-01} and \code{2000-03-01} is \code{1} (i.e. one month).
The \strong{duration} between these two dates is \code{0.95}, which accounts for the fact
that the year 2000 is a leap year, February has 29 days, and the average month
length is \code{30.4375}, i.e. \code{29 / 30.4375 = 0.95}.

For additional details, review the
\href{https://lubridate.tidyverse.org/reference/timespan.html}{lubridate time span reference page}.
}
\examples{
library(tibble)
library(lubridate)

data <- tribble(
  ~BRTHDT, ~RANDDT,
  ymd("1984-09-06"), ymd("2020-02-24")
)

derive_vars_aage(data)
}
\seealso{
\code{\link[=derive_vars_duration]{derive_vars_duration()}}

ADSL Functions that returns variable appended to dataset: 
\code{\link{derive_var_age_years}()},
\code{\link{derive_vars_extreme_event}()},
\code{\link{derive_vars_period}()}
}
\concept{der_adsl}
\keyword{der_adsl}
